/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes.support;

import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.stub.StubComponent;
import org.apache.camel.impl.engine.DefaultComponentResolver;

public final class StubComponentResolver
extends DefaultComponentResolver {
    private static final Set<String> ACCEPTED_STUB_NAMES = Set.of("stub", "bean", "class", "direct", "kamelet", "log", "rest", "rest-api", "seda", "vertx-http");
    private final Set<String> names = new TreeSet<String>();
    private final String stubPattern;
    private final boolean silent;

    public StubComponentResolver(String stubPattern, boolean silent) {
        this.stubPattern = stubPattern;
        this.silent = silent;
    }

    public Component resolveComponent(String name, CamelContext context) {
        boolean accept = this.accept(name);
        Component answer = super.resolveComponent(accept ? name : "stub", context);
        if ((this.silent || this.stubPattern != null) && answer instanceof StubComponent) {
            StubComponent sc = (StubComponent)answer;
            sc.setShadow(true);
            sc.setShadowPattern(this.stubPattern);
        }
        this.names.add(name);
        return answer;
    }

    private boolean accept(String name) {
        if (this.stubPattern == null) {
            return true;
        }
        return ACCEPTED_STUB_NAMES.contains(name);
    }

    public Set<String> getNames() {
        return Set.copyOf(this.names);
    }
}

