/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.kubernetes;

import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesBaseCommand;
import org.apache.camel.dsl.jbang.core.commands.kubernetes.KubernetesHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"Delete Camel application from Kubernetes"}, sortOptions=false)
public class KubernetesDelete
extends KubernetesBaseCommand {
    @CommandLine.Parameters(description={"The Camel file to delete. Integration name is derived from the file name."}, arity="0..1", paramLabel="<file>")
    String filePath;
    @CommandLine.Option(names={"--working-dir"}, description={"The working directory where to find exported project sources."})
    String workingDir;
    @CommandLine.Option(names={"--cluster-type"}, description={"The target cluster type. Special configurations may be applied to different cluster types such as Kind or Minikube or Openshift. If a target cluster type was set to create the project (run/export command), it needs to be set."})
    protected String clusterType;

    public KubernetesDelete(CamelJBangMain main) {
        super(main);
        this.projectNameSuppliers.add(() -> this.projectNameFromFilePath(() -> this.filePath));
    }

    public Integer doCall() throws Exception {
        File resolvedWorkingDir;
        File candidateDir;
        File resolvedWorkingDir2;
        File candidateDir2;
        File resolvedManifestDir = null;
        if (this.workingDir != null && (candidateDir2 = new File(resolvedWorkingDir2 = new File(this.workingDir), "target/kubernetes")).isDirectory()) {
            resolvedManifestDir = candidateDir2;
        }
        String projectName = this.getProjectName();
        if (resolvedManifestDir == null && (candidateDir = new File(resolvedWorkingDir = new File(".camel-jbang-run/" + projectName), "target/kubernetes")).isDirectory()) {
            resolvedManifestDir = candidateDir;
        }
        if (resolvedManifestDir == null && (candidateDir2 = new File("./target/kubernetes")).isDirectory()) {
            resolvedManifestDir = candidateDir2;
        }
        if (resolvedManifestDir == null) {
            this.printer().printErr("Failed to resolve exported project: %s".formatted(projectName));
            return 1;
        }
        File manifest = KubernetesHelper.resolveKubernetesManifest(this.clusterType, resolvedManifestDir);
        this.printer().printf("Deleting resources from manifest: %s%n", new Object[]{manifest});
        try (FileInputStream fis = new FileInputStream(manifest);){
            List status;
            NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable loadedResources = this.client().load((InputStream)fis);
            if (!ObjectHelper.isEmpty((String)this.namespace)) {
                status = ((ListVisitFromServerGetDeleteRecreateWaitApplicable)loadedResources.inNamespace(this.namespace)).delete();
            } else {
                status = loadedResources.delete();
                if (status.isEmpty()) {
                    status = ((ListVisitFromServerGetDeleteRecreateWaitApplicable)loadedResources.inNamespace("default")).delete();
                }
            }
            status.forEach(s -> this.printer().printf("Deleted: %s '%s'%n", new Object[]{StringHelper.capitalize((String)s.getKind()), s.getName()}));
        }
        return 0;
    }
}

