/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands.edit;

import com.github.cameltooling.lsp.internal.CamelTextDocumentService;
import com.github.cameltooling.lsp.internal.diagnostic.CamelKModelineDiagnosticService;
import com.github.cameltooling.lsp.internal.diagnostic.ConfigurationPropertiesDiagnosticService;
import com.github.cameltooling.lsp.internal.diagnostic.ConnectedModeDiagnosticService;
import com.github.cameltooling.lsp.internal.diagnostic.EndpointDiagnosticService;
import com.github.cameltooling.lsp.internal.settings.SettingsManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.camel.tooling.util.Strings;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemTag;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jline.builtins.ConfigurationPath;
import org.jline.builtins.Nano;
import org.jline.builtins.Options;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;

public class CamelNanoLspEditor
extends Nano {
    private final LocalCamelDocumentService camelDocumentService = new LocalCamelDocumentService();

    public CamelNanoLspEditor(Terminal terminal, Path root, Options opts) {
        this(terminal, root, opts, null);
    }

    public CamelNanoLspEditor(Terminal terminal, Path root, Options opts, ConfigurationPath configPath) {
        super(terminal, root, opts, configPath);
        this.mouseSupport = true;
    }

    protected List<Nano.Diagnostic> computeDiagnostic() {
        String fileName = this.buffer.getFile();
        String text = String.join((CharSequence)"\n", this.buffer.getLines()) + "\n";
        TextDocumentItem textDocumentItem = new TextDocumentItem(fileName, "LANGUAGE_ID_APACHE_CAMEL", 0, text);
        return this.camelDocumentService.computeDiagnostic(textDocumentItem);
    }

    protected LinkedHashMap<AttributedString, List<AttributedString>> computeSuggestions() {
        LinkedHashMap<AttributedString, List<AttributedString>> suggestions = new LinkedHashMap<AttributedString, List<AttributedString>>();
        String fileName = this.buffer.getFile();
        StringBuilder text = new StringBuilder();
        for (String line : this.buffer.getLines()) {
            text.append(line);
            text.append('\n');
        }
        TextDocumentItem textDocumentItem = new TextDocumentItem(fileName, "LANGUAGE_ID_APACHE_CAMEL", 0, text.toString());
        CompletableFuture<Either<List<CompletionItem>, CompletionList>> eitherCompletableFuture = this.camelDocumentService.completionLocal(textDocumentItem, new Position(this.buffer.getLine(), this.buffer.getOffsetInLine() + this.buffer.getColumn()));
        if (eitherCompletableFuture.isCompletedExceptionally()) {
            return suggestions;
        }
        try {
            List left = (List)eitherCompletableFuture.get().getLeft();
            for (CompletionItem item : left) {
                String doc;
                Either docMap;
                List tags;
                ArrayList<AttributedString> docs = new ArrayList<AttributedString>();
                docs.add(new AttributedString((CharSequence)item.getLabel(), AttributedStyle.BOLD));
                docs.add(new AttributedString((CharSequence)""));
                String type = item.getDetail();
                if (!Strings.isEmpty((String)type)) {
                    docs.add(new AttributedString((CharSequence)("Type: " + type)));
                }
                if ((tags = item.getTags()) != null && tags.contains(CompletionItemTag.Deprecated)) {
                    docs.add(new AttributedString((CharSequence)"Deprecated: true"));
                }
                if ((docMap = item.getDocumentation()) != null && !Strings.isEmpty((String)(doc = (String)docMap.getLeft()))) {
                    doc.lines().forEach(s -> docs.add(new AttributedString((CharSequence)s)));
                }
                suggestions.put(new AttributedString((CharSequence)item.getLabel()), docs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return suggestions;
    }

    protected void insertHelp(int selected) {
        List lines;
        String fileName = this.buffer.getFile();
        StringBuilder text = new StringBuilder();
        for (String line : this.buffer.getLines()) {
            text.append(line);
            text.append('\n');
        }
        TextDocumentItem textDocumentItem = new TextDocumentItem(fileName, "LANGUAGE_ID_APACHE_CAMEL", 0, text.toString());
        CompletableFuture<Either<List<CompletionItem>, CompletionList>> eitherCompletableFuture = this.camelDocumentService.completionLocal(textDocumentItem, new Position(this.buffer.getLine(), this.buffer.getOffsetInLine() + this.buffer.getColumn()));
        try {
            lines = (List)eitherCompletableFuture.get().getLeft();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        CompletionItem item = (CompletionItem)lines.get(selected);
        Either textEdit = item.getTextEdit();
        if (textEdit != null) {
            TextEdit left = (TextEdit)textEdit.getLeft();
            Range range = left.getRange();
            Position start = range.getStart();
            int endLine = start.getLine();
            Position end = range.getEnd();
            int startLine = end.getLine();
            if (startLine == endLine) {
                StringBuilder newLine = new StringBuilder();
                String line = (String)this.buffer.getLines().get(startLine);
                newLine.append(line, 0, start.getCharacter());
                newLine.append(left.getNewText());
                newLine.append(line.substring(end.getCharacter()));
                this.buffer.getLines().set(startLine, newLine.toString());
                this.buffer.moveRight(left.getNewText().length());
            } else {
                StringBuilder newFirstLine = new StringBuilder();
                String oldFirstLine = (String)this.buffer.getLines().get(startLine);
                String newText = left.getNewText();
                newFirstLine.append(oldFirstLine, 0, start.getCharacter());
                newFirstLine.append(newText, 0, oldFirstLine.length() - start.getCharacter());
                this.buffer.getLines().set(startLine, newFirstLine.toString());
                StringBuilder newSecondLine = new StringBuilder();
                String oldSecondLine = (String)this.buffer.getLines().get(endLine);
                newSecondLine.append(newText, oldFirstLine.length() - start.getCharacter(), end.getCharacter());
                newSecondLine.append(oldSecondLine, end.getCharacter(), end.getCharacter());
                this.buffer.getLines().set(endLine, newSecondLine.toString());
                this.buffer.moveRight(left.getNewText().length());
            }
        } else if (!Strings.isEmpty((String)item.getInsertText()) || !Strings.isEmpty((String)item.getLabel())) {
            String insert = Strings.isEmpty((String)item.getInsertText()) ? item.getLabel() : item.getInsertText();
            StringBuilder newLine = new StringBuilder();
            String line = (String)this.buffer.getLines().get(this.buffer.getLine());
            newLine.append(line, 0, this.buffer.getOffsetInLine() + this.buffer.getColumn());
            newLine.append(insert);
            this.buffer.getLines().set(this.buffer.getLine(), newLine.toString());
            this.buffer.moveRight(insert.length());
        }
        this.buffer.setDirty(true);
    }

    private static class LocalCamelDocumentService
    extends CamelTextDocumentService {
        private final EndpointDiagnosticService endpointDiagnosticService = new EndpointDiagnosticService(this.getCamelCatalog());
        private final ConfigurationPropertiesDiagnosticService configurationPropertiesDiagnosticService = new ConfigurationPropertiesDiagnosticService(this.getCamelCatalog());
        private final CamelKModelineDiagnosticService camelKModelineDiagnosticService = new CamelKModelineDiagnosticService();
        private final ConnectedModeDiagnosticService connectedModeDiagnosticService = new ConnectedModeDiagnosticService();

        private LocalCamelDocumentService() {
            super(null);
        }

        private CompletableFuture<Either<List<CompletionItem>, CompletionList>> completionLocal(TextDocumentItem textDocument, Position position) {
            String uri = textDocument.getUri();
            this.openedDocuments.put(uri, textDocument);
            return super.completion(new CompletionParams(new TextDocumentIdentifier(uri), position));
        }

        public SettingsManager getSettingsManager() {
            return new SettingsManager((CamelTextDocumentService)this);
        }

        private List<Nano.Diagnostic> computeDiagnostic(TextDocumentItem documentItem) {
            String uri = documentItem.getUri();
            String camelText = documentItem.getText();
            Map endpointErrors = this.endpointDiagnosticService.computeCamelEndpointErrors(camelText, uri);
            List diagnostics = this.endpointDiagnosticService.converToLSPDiagnostics(camelText, endpointErrors, documentItem);
            Map configurationPropertiesErrors = this.configurationPropertiesDiagnosticService.computeCamelConfigurationPropertiesErrors(camelText, uri);
            diagnostics.addAll(this.configurationPropertiesDiagnosticService.converToLSPDiagnostics(configurationPropertiesErrors));
            diagnostics.addAll(this.camelKModelineDiagnosticService.compute(camelText, documentItem));
            diagnostics.addAll(this.connectedModeDiagnosticService.compute(camelText, documentItem));
            diagnostics.addAll(this.connectedModeDiagnosticService.compute(camelText, documentItem));
            return diagnostics.stream().map(diag -> new DiagnosticWrapper((Diagnostic)diag)).toList();
        }

        private static class DiagnosticWrapper
        implements Nano.Diagnostic {
            private final Diagnostic diag;

            public DiagnosticWrapper(Diagnostic diag) {
                this.diag = diag;
            }

            public int getStartLine() {
                return this.diag.getRange().getStart().getLine();
            }

            public int getStartColumn() {
                return this.diag.getRange().getStart().getCharacter();
            }

            public int getEndLine() {
                return this.diag.getRange().getEnd().getLine();
            }

            public int getEndColumn() {
                return this.diag.getRange().getEnd().getCharacter();
            }

            public String getMessage() {
                return this.diag.getMessage();
            }
        }
    }
}

