/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.TypeConverter;
import org.apache.camel.converter.jaxb.FilteringXmlStreamWriter;
import org.apache.camel.converter.jaxb.JaxbHelper;
import org.apache.camel.converter.jaxb.JaxbNamespacePrefixMapper;
import org.apache.camel.converter.jaxb.JaxbXmlStreamWriterWrapper;
import org.apache.camel.converter.jaxb.NamespacePrefixMapperFactory;
import org.apache.camel.converter.jaxb.NonXmlFilterReader;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatContentTypeHeader;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Dataformat(value="jaxb")
public class JaxbDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
DataFormatContentTypeHeader,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(JaxbDataFormat.class);
    private static final BlockingQueue<SchemaFactory> SCHEMA_FACTORY_POOL = new LinkedBlockingQueue<SchemaFactory>();
    private SchemaFactory schemaFactory;
    private CamelContext camelContext;
    private JAXBContext context;
    private JAXBIntrospector introspector;
    private String contextPath;
    private boolean contextPathIsClassName;
    private String schema;
    private int schemaSeverityLevel;
    private String schemaLocation;
    private String noNamespaceSchemaLocation;
    private boolean prettyPrint = true;
    private boolean objectFactory = true;
    private boolean ignoreJAXBElement = true;
    private boolean mustBeJAXBElement;
    private boolean filterNonXmlChars;
    private String encoding;
    private boolean fragment;
    private QName partNamespace;
    private Class<?> partClass;
    private Map<String, String> namespacePrefix;
    private JaxbNamespacePrefixMapper namespacePrefixMapper;
    private JaxbXmlStreamWriterWrapper xmlStreamWriterWrapper;
    private TypeConverter typeConverter;
    private Schema cachedSchema;
    private Map<String, Object> jaxbProviderProperties;
    private boolean contentTypeHeader = true;

    public JaxbDataFormat() {
    }

    public JaxbDataFormat(JAXBContext context) {
        this.context = context;
    }

    public JaxbDataFormat(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getDataFormatName() {
        return "jaxb";
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws IOException {
        try {
            Map<String, Object> customProperties;
            String charset;
            Marshaller marshaller = this.createMarshaller();
            if (this.isPrettyPrint()) {
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            if ((charset = (String)exchange.getProperty("CamelCharsetName", String.class)) == null && (charset = this.encoding) != null) {
                exchange.setProperty("CamelCharsetName", (Object)charset);
            }
            if (charset != null) {
                marshaller.setProperty("jaxb.encoding", (Object)charset);
            }
            if (this.isFragment()) {
                marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            }
            if (ObjectHelper.isNotEmpty((Object)this.schemaLocation)) {
                marshaller.setProperty("jaxb.schemaLocation", (Object)this.schemaLocation);
            }
            if (ObjectHelper.isNotEmpty((Object)this.noNamespaceSchemaLocation)) {
                marshaller.setProperty("jaxb.noNamespaceSchemaLocation", (Object)this.noNamespaceSchemaLocation);
            }
            if (this.namespacePrefixMapper != null) {
                marshaller.setProperty(this.namespacePrefixMapper.getRegistrationKey(), (Object)this.namespacePrefixMapper);
            }
            if ((customProperties = (Map<String, Object>)exchange.getProperty("CamelJaxbProviderProperties", Map.class)) == null) {
                customProperties = this.getJaxbProviderProperties();
            }
            if (customProperties != null) {
                for (Map.Entry<String, Object> property : customProperties.entrySet()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Using JAXB Provider Property {}={}", (Object)property.getKey(), property.getValue());
                    }
                    marshaller.setProperty(property.getKey(), property.getValue());
                }
            }
            this.doMarshal(exchange, graph, stream, marshaller, charset);
            if (this.contentTypeHeader) {
                if (exchange.hasOut()) {
                    exchange.getOut().setHeader("Content-Type", (Object)"application/xml");
                } else {
                    exchange.getIn().setHeader("Content-Type", (Object)"application/xml");
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    void doMarshal(Exchange exchange, Object graph, OutputStream stream, Marshaller marshaller, String charset) throws Exception {
        Method objectFactoryMethod;
        Object element = graph;
        QName partNamespaceOnDataFormat = this.getPartNamespace();
        String partClassFromHeader = (String)exchange.getIn().getHeader("CamelJaxbPartClass", String.class);
        String partNamespaceFromHeader = (String)exchange.getIn().getHeader("CamelJaxbPartNamespace", String.class);
        if (!(this.partClass == null && partClassFromHeader == null || partNamespaceOnDataFormat == null && partNamespaceFromHeader == null)) {
            if (partClassFromHeader != null) {
                try {
                    this.partClass = this.camelContext.getClassResolver().resolveMandatoryClass(partClassFromHeader, Object.class);
                }
                catch (ClassNotFoundException e) {
                    throw new JAXBException((Throwable)e);
                }
            }
            if (partNamespaceFromHeader != null) {
                partNamespaceOnDataFormat = QName.valueOf(partNamespaceFromHeader);
            }
            element = new JAXBElement(partNamespaceOnDataFormat, this.partClass, graph);
        }
        if (this.introspector.isElement(element)) {
            if (this.asXmlStreamWriter(exchange)) {
                XMLStreamWriter writer = (XMLStreamWriter)this.typeConverter.convertTo(XMLStreamWriter.class, exchange, (Object)stream);
                if (this.needFiltering(exchange)) {
                    writer = new FilteringXmlStreamWriter(writer, charset);
                }
                if (this.xmlStreamWriterWrapper != null) {
                    writer = this.xmlStreamWriterWrapper.wrapWriter(writer);
                }
                marshaller.marshal(element, writer);
            } else {
                marshaller.marshal(element, stream);
            }
            return;
        }
        if (this.objectFactory && element != null && (objectFactoryMethod = JaxbHelper.getJaxbElementFactoryMethod(this.camelContext, element.getClass())) != null) {
            try {
                Object instance = objectFactoryMethod.getDeclaringClass().newInstance();
                if (instance != null) {
                    Object toMarshall = objectFactoryMethod.invoke(instance, element);
                    if (this.asXmlStreamWriter(exchange)) {
                        XMLStreamWriter writer = (XMLStreamWriter)this.typeConverter.convertTo(XMLStreamWriter.class, exchange, (Object)stream);
                        if (this.needFiltering(exchange)) {
                            writer = new FilteringXmlStreamWriter(writer, charset);
                        }
                        if (this.xmlStreamWriterWrapper != null) {
                            writer = this.xmlStreamWriterWrapper.wrapWriter(writer);
                        }
                        marshaller.marshal(toMarshall, writer);
                    } else {
                        marshaller.marshal(toMarshall, stream);
                    }
                    return;
                }
            }
            catch (Exception e) {
                if (MarshalException.class.isAssignableFrom(e.getClass()) && this.schema != null) {
                    throw e;
                }
                LOG.debug("Unable to create JAXBElement object for type " + element.getClass() + " due to " + e.getMessage(), (Throwable)e);
            }
        }
        if (!this.mustBeJAXBElement) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Attempt to marshalling non JAXBElement with type {} as InputStream", (Object)ObjectHelper.classCanonicalName((Object)graph));
            }
        } else {
            throw new InvalidPayloadException(exchange, JAXBElement.class);
        }
        InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, graph);
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)stream);
    }

    private boolean asXmlStreamWriter(Exchange exchange) {
        return this.needFiltering(exchange) || this.xmlStreamWriterWrapper != null;
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws IOException {
        try {
            Object answer;
            XMLStreamReader xmlReader = this.needFiltering(exchange) ? (XMLStreamReader)this.typeConverter.convertTo(XMLStreamReader.class, exchange, (Object)this.createNonXmlFilterReader(exchange, stream)) : (XMLStreamReader)this.typeConverter.convertTo(XMLStreamReader.class, exchange, (Object)stream);
            String partClassFromHeader = (String)exchange.getIn().getHeader("CamelJaxbPartClass", String.class);
            if (this.partClass != null || partClassFromHeader != null) {
                if (partClassFromHeader != null) {
                    try {
                        this.partClass = this.camelContext.getClassResolver().resolveMandatoryClass(partClassFromHeader, Object.class);
                    }
                    catch (ClassNotFoundException e) {
                        throw new JAXBException((Throwable)e);
                    }
                }
                answer = this.createUnmarshaller().unmarshal(xmlReader, this.partClass);
            } else {
                answer = this.createUnmarshaller().unmarshal(xmlReader);
            }
            if (answer instanceof JAXBElement && this.isIgnoreJAXBElement()) {
                answer = ((JAXBElement)answer).getValue();
            }
            return answer;
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    private NonXmlFilterReader createNonXmlFilterReader(Exchange exchange, InputStream stream) throws UnsupportedEncodingException {
        return new NonXmlFilterReader(new InputStreamReader(stream, ExchangeHelper.getCharsetName((Exchange)exchange)));
    }

    protected boolean needFiltering(Exchange exchange) {
        return exchange == null ? this.filterNonXmlChars : (Boolean)exchange.getProperty("CamelFilterNonXmlChars", (Object)this.filterNonXmlChars, Boolean.class);
    }

    public boolean isIgnoreJAXBElement() {
        return this.ignoreJAXBElement;
    }

    public void setIgnoreJAXBElement(boolean flag) {
        this.ignoreJAXBElement = flag;
    }

    public boolean isMustBeJAXBElement() {
        return this.mustBeJAXBElement;
    }

    public void setMustBeJAXBElement(boolean mustBeJAXBElement) {
        this.mustBeJAXBElement = mustBeJAXBElement;
    }

    public JAXBContext getContext() {
        return this.context;
    }

    public void setContext(JAXBContext context) {
        this.context = context;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public boolean isContextPathIsClassName() {
        return this.contextPathIsClassName;
    }

    public void setContextPathIsClassName(boolean contextPathIsClassName) {
        this.contextPathIsClassName = contextPathIsClassName;
    }

    public SchemaFactory getSchemaFactory() {
        if (this.schemaFactory == null) {
            return this.getOrCreateSchemaFactory();
        }
        return this.schemaFactory;
    }

    public void setSchemaFactory(SchemaFactory schemaFactory) {
        this.schemaFactory = schemaFactory;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public int getSchemaSeverityLevel() {
        return this.schemaSeverityLevel;
    }

    public void setSchemaSeverityLevel(int schemaSeverityLevel) {
        this.schemaSeverityLevel = schemaSeverityLevel;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(boolean objectFactory) {
        this.objectFactory = objectFactory;
    }

    public boolean isFragment() {
        return this.fragment;
    }

    public void setFragment(boolean fragment) {
        this.fragment = fragment;
    }

    public boolean isFilterNonXmlChars() {
        return this.filterNonXmlChars;
    }

    public void setFilterNonXmlChars(boolean filterNonXmlChars) {
        this.filterNonXmlChars = filterNonXmlChars;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public QName getPartNamespace() {
        return this.partNamespace;
    }

    public void setPartNamespace(QName partNamespace) {
        this.partNamespace = partNamespace;
    }

    public Class<?> getPartClass() {
        return this.partClass;
    }

    public void setPartClass(Class<?> partClass) {
        this.partClass = partClass;
    }

    public Map<String, String> getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void setNamespacePrefix(Map<String, String> namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public JaxbXmlStreamWriterWrapper getXmlStreamWriterWrapper() {
        return this.xmlStreamWriterWrapper;
    }

    public void setXmlStreamWriterWrapper(JaxbXmlStreamWriterWrapper xmlStreamWriterWrapper) {
        this.xmlStreamWriterWrapper = xmlStreamWriterWrapper;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public String getNoNamespaceSchemaLocation() {
        return this.schemaLocation;
    }

    public void setNoNamespaceSchemaLocation(String schemaLocation) {
        this.noNamespaceSchemaLocation = schemaLocation;
    }

    public Map<String, Object> getJaxbProviderProperties() {
        return this.jaxbProviderProperties;
    }

    public void setJaxbProviderProperties(Map<String, Object> jaxbProviderProperties) {
        this.jaxbProviderProperties = jaxbProviderProperties;
    }

    public boolean isContentTypeHeader() {
        return this.contentTypeHeader;
    }

    public void setContentTypeHeader(boolean contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext");
        if (this.context == null) {
            this.context = this.createContext();
        }
        this.introspector = this.context.createJAXBIntrospector();
        if (this.namespacePrefix != null) {
            this.namespacePrefixMapper = NamespacePrefixMapperFactory.newNamespacePrefixMapper(this.camelContext, this.namespacePrefix);
        }
        this.typeConverter = this.camelContext.getTypeConverter();
        if (this.schema != null) {
            this.cachedSchema = this.createSchema(this.getSources());
        }
        LOG.debug("JaxbDataFormat [prettyPrint={}, objectFactory={}]", (Object)this.prettyPrint, (Object)this.objectFactory);
    }

    protected void doStop() throws Exception {
    }

    protected JAXBContext createContext() throws Exception {
        if (this.contextPath != null) {
            ClassLoader cl = this.camelContext.getApplicationContextClassLoader();
            if (cl != null) {
                if (this.contextPathIsClassName) {
                    LOG.debug("Creating JAXBContext with className: " + this.contextPath + " and ApplicationContextClassLoader: " + cl);
                    Class clazz = this.camelContext.getClassResolver().resolveMandatoryClass(this.contextPath, cl);
                    return JAXBContext.newInstance((Class[])new Class[]{clazz});
                }
                LOG.debug("Creating JAXBContext with contextPath: " + this.contextPath + " and ApplicationContextClassLoader: " + cl);
                return JAXBContext.newInstance((String)this.contextPath, (ClassLoader)cl);
            }
            if (this.contextPathIsClassName) {
                LOG.debug("Creating JAXBContext with className: {}", (Object)this.contextPath);
                Class clazz = this.camelContext.getClassResolver().resolveMandatoryClass(this.contextPath);
                return JAXBContext.newInstance((Class[])new Class[]{clazz});
            }
            LOG.debug("Creating JAXBContext with contextPath: {}", (Object)this.contextPath);
            return JAXBContext.newInstance((String)this.contextPath);
        }
        LOG.debug("Creating JAXBContext");
        return JAXBContext.newInstance((Class[])new Class[0]);
    }

    protected Unmarshaller createUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = this.getContext().createUnmarshaller();
        if (this.schema != null) {
            unmarshaller.setSchema(this.cachedSchema);
            unmarshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    return event.getSeverity() < JaxbDataFormat.this.getSchemaSeverityLevel();
                }
            });
        }
        return unmarshaller;
    }

    protected Marshaller createMarshaller() throws JAXBException {
        Marshaller marshaller = this.getContext().createMarshaller();
        if (this.schema != null) {
            marshaller.setSchema(this.cachedSchema);
            marshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    return event.getSeverity() < JaxbDataFormat.this.getSchemaSeverityLevel();
                }
            });
        }
        return marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema createSchema(Source[] sources) throws SAXException {
        SchemaFactory factory = this.getOrCreateSchemaFactory();
        try {
            Schema schema = factory.newSchema(sources);
            return schema;
        }
        finally {
            this.returnSchemaFactory(factory);
        }
    }

    private Source[] getSources() throws FileNotFoundException, MalformedURLException {
        String[] schemas = this.schema.split(",");
        Source[] sources = new Source[schemas.length];
        for (int i = 0; i < schemas.length; ++i) {
            URL schemaUrl = ResourceHelper.resolveMandatoryResourceAsUrl((ClassResolver)this.camelContext.getClassResolver(), (String)schemas[i]);
            sources[i] = new StreamSource(schemaUrl.toExternalForm());
        }
        return sources;
    }

    private SchemaFactory getOrCreateSchemaFactory() {
        SchemaFactory factory = (SchemaFactory)SCHEMA_FACTORY_POOL.poll();
        if (factory == null) {
            factory = JaxbDataFormat.createSchemaFactory();
        }
        return factory;
    }

    public static SchemaFactory createSchemaFactory() {
        return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    }

    private void returnSchemaFactory(SchemaFactory factory) {
        if (factory != this.schemaFactory) {
            SCHEMA_FACTORY_POOL.offer(factory);
        }
    }
}

