/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.IOHelper;

public class JaxbDataFormat
implements DataFormat {
    private JAXBContext context;
    private String contextPath;
    private boolean prettyPrint = true;
    private boolean ignoreJAXBElement = true;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public JaxbDataFormat() {
    }

    public JaxbDataFormat(JAXBContext context) {
        this.context = context;
    }

    public JaxbDataFormat(String contextPath) {
        this.contextPath = contextPath;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws IOException {
        try {
            this.getMarshaller().marshal(graph, stream);
        }
        catch (JAXBException e) {
            throw IOHelper.createIOException((Throwable)e);
        }
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws IOException, ClassNotFoundException {
        try {
            Object answer = this.getUnmarshaller().unmarshal(stream);
            if (answer instanceof JAXBElement && this.isIgnoreJAXBElement()) {
                answer = ((JAXBElement)answer).getValue();
            }
            return answer;
        }
        catch (JAXBException e) {
            throw IOHelper.createIOException((Throwable)e);
        }
    }

    public boolean isIgnoreJAXBElement() {
        return this.ignoreJAXBElement;
    }

    public void setIgnoreJAXBElement(boolean flag) {
        this.ignoreJAXBElement = flag;
    }

    public JAXBContext getContext() throws JAXBException {
        if (this.context == null) {
            this.context = this.createContext();
        }
        return this.context;
    }

    public void setContext(JAXBContext context) {
        this.context = context;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public Marshaller getMarshaller() throws JAXBException {
        if (this.marshaller == null) {
            this.marshaller = this.getContext().createMarshaller();
        }
        return this.marshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public Unmarshaller getUnmarshaller() throws JAXBException {
        if (this.unmarshaller == null) {
            this.unmarshaller = this.getContext().createUnmarshaller();
        }
        return this.unmarshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    protected JAXBContext createContext() throws JAXBException {
        if (this.contextPath != null) {
            return JAXBContext.newInstance((String)this.contextPath);
        }
        return JAXBContext.newInstance((Class[])new Class[0]);
    }
}

