/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.java.joor;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dsl.java.joor.CompilationUnit;
import org.apache.camel.dsl.java.joor.Helper;
import org.apache.camel.dsl.java.joor.JavaJoorClassLoader;
import org.apache.camel.dsl.java.joor.MultiCompile;
import org.apache.camel.dsl.support.ExtendedRouteBuilderLoaderSupport;
import org.apache.camel.spi.CompilePostProcessor;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceAware;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.support.RouteWatcherReloadStrategy;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed JavaRoutesBuilderLoader")
@RoutesLoader(value="java")
public class JavaRoutesBuilderLoader
extends ExtendedRouteBuilderLoaderSupport {
    public static final String EXTENSION = "java";
    private static final Logger LOG = LoggerFactory.getLogger(JavaRoutesBuilderLoader.class);

    public JavaRoutesBuilderLoader() {
        super(EXTENSION);
    }

    protected void doBuild() throws Exception {
        super.doBuild();
        CamelContext context = this.getCamelContext();
        if (context != null) {
            JavaJoorClassLoader cl = new JavaJoorClassLoader();
            context.getClassResolver().addClassLoader((ClassLoader)cl);
            this.addCompilePostProcessor(cl);
        }
    }

    protected RouteBuilder doLoadRouteBuilder(Resource resource) throws Exception {
        Collection<RoutesBuilder> answer = this.doLoadRoutesBuilders(List.of(resource));
        if (answer.size() == 1) {
            RoutesBuilder builder = answer.iterator().next();
            return (RouteBuilder)builder;
        }
        return super.doLoadRouteBuilder(resource);
    }

    protected Collection<RoutesBuilder> doLoadRoutesBuilders(Collection<Resource> resources) throws Exception {
        ArrayList<RoutesBuilder> answer = new ArrayList<RoutesBuilder>();
        LOG.debug("Loading .java resources from: {}", resources);
        CompilationUnit unit = CompilationUnit.input();
        HashMap<String, Resource> nameToResource = new HashMap<String, Resource>();
        for (Resource resource : resources) {
            InputStream is = this.resourceInputStream(resource);
            try {
                if (is == null) {
                    throw new FileNotFoundException(resource.getLocation());
                }
                String content = IOHelper.loadText((InputStream)is);
                String name = Helper.determineName(resource, content);
                unit.addClass(name, content);
                nameToResource.put(name, resource);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        LOG.debug("Compiling unit: {}", (Object)unit);
        CompilationUnit.Result result = MultiCompile.compileUnit(unit);
        if (this.getCamelContext().hasService(RouteWatcherReloadStrategy.class) != null) {
            this.getCamelContext().getRegistry().bind("RouteWatcherReloadResources", nameToResource.values());
        }
        for (String className : result.getClassNames()) {
            Object obj = null;
            Class<?> clazz = result.getClass(className);
            if (clazz != null) {
                boolean skip = clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || Modifier.isPrivate(clazz.getModifiers());
                boolean ctr = ObjectHelper.hasDefaultNoArgConstructor(clazz);
                if (ctr && !skip) {
                    try {
                        obj = this.getCamelContext().getInjector().newInstance(clazz);
                        if (obj != null) {
                            LOG.debug("Compiled: {} -> {}", (Object)className, obj);
                            CamelContextAware.trySetCamelContext((Object)obj, (CamelContext)this.getCamelContext());
                            ResourceAware.trySetResource((Object)obj, (Resource)((Resource)nameToResource.get(className)));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeCamelException("Cannot create instance of class: " + className, (Throwable)e);
                    }
                }
            }
            for (CompilePostProcessor pre : this.getCompilePostProcessors()) {
                byte[] byteCode = result.getByteCode(className);
                pre.postCompile(this.getCamelContext(), className, clazz, byteCode, obj);
            }
            if (!(obj instanceof RouteBuilder)) continue;
            RouteBuilder builder = (RouteBuilder)obj;
            answer.add((RoutesBuilder)builder);
        }
        return answer;
    }
}

