/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jandex;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.scan.AnnotatedWithAnyPackageScanFilter;
import org.apache.camel.support.scan.AnnotatedWithPackageScanFilter;
import org.apache.camel.support.scan.AssignableToPackageScanFilter;
import org.apache.camel.support.scan.DefaultPackageScanClassResolver;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="jandex-class-resolver")
public class JandexPackageScanClassResolver
extends DefaultPackageScanClassResolver {
    private static final Logger LOG = LoggerFactory.getLogger(JandexPackageScanClassResolver.class);
    private static final String INDEX = "classpath:META-INF/jandex.*";
    private final List<Index> indexes = new ArrayList<Index>();

    protected void doStart() throws Exception {
        super.doStart();
        PackageScanResourceResolver resolver = PluginHelper.getPackageScanResourceResolver((CamelContext)this.getCamelContext());
        resolver.addClassLoader(this.getCamelContext().getApplicationContextClassLoader());
        resolver.start();
        Collection list = resolver.findResources(INDEX);
        for (Resource res : list) {
            if (!res.getLocation().endsWith("jandex.idx")) continue;
            InputStream is = res.getInputStream();
            try {
                if (is == null) continue;
                LOG.debug("Reading jandex.idx from: {}", (Object)res.getLocation());
                Index index = new IndexReader(is).read();
                this.indexes.add(index);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.indexes.clear();
    }

    protected void find(PackageScanFilter test, String packageName, ClassLoader loader, Set<Class<?>> classes) {
        AnnotatedWithPackageScanFilter ann;
        if (test instanceof AnnotatedWithPackageScanFilter) {
            ann = (AnnotatedWithPackageScanFilter)test;
            this.findByAnnotation(ann.getAnnotation(), classes);
        }
        if (test instanceof AnnotatedWithAnyPackageScanFilter) {
            ann = (AnnotatedWithAnyPackageScanFilter)test;
            for (Class c : ann.getAnnotations()) {
                this.findByAnnotation(c, classes);
            }
        }
        if (test instanceof AssignableToPackageScanFilter) {
            ann = (AssignableToPackageScanFilter)test;
            for (Class c : ann.getParents()) {
                this.findBySubClass(c, classes);
            }
        }
    }

    private void findByAnnotation(Class<? extends Annotation> c, Set<Class<?>> classes) {
        for (Index index : this.indexes) {
            block3: for (AnnotationInstance ai : index.getAnnotations(c)) {
                AnnotationTarget at = ai.target();
                if (at.kind() != AnnotationTarget.Kind.CLASS || at.asClass().nestingType() != ClassInfo.NestingType.TOP_LEVEL || at.asClass().isAbstract()) continue;
                String currentClass = at.asClass().name().toString();
                for (ClassLoader cl : this.getClassLoaders()) {
                    try {
                        Class<?> clazz = cl.loadClass(currentClass);
                        classes.add(clazz);
                        continue block3;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
            }
        }
    }

    private void findBySubClass(Class<?> c, Set<Class<?>> classes) {
        for (Index index : this.indexes) {
            Class<?> clazz;
            String currentClass;
            if (c.isInterface()) {
                block5: for (ClassInfo ai : index.getAllKnownImplementations(c)) {
                    if (ai.asClass().isAbstract()) continue;
                    currentClass = ai.asClass().name().toString();
                    for (ClassLoader cl : this.getClassLoaders()) {
                        try {
                            clazz = cl.loadClass(currentClass);
                            classes.add(clazz);
                            continue block5;
                        }
                        catch (ClassNotFoundException clazz2) {
                        }
                    }
                }
                continue;
            }
            block7: for (ClassInfo ai : index.getAllKnownSubclasses(c)) {
                if (ai.isAbstract()) continue;
                currentClass = ai.asClass().name().toString();
                for (ClassLoader cl : this.getClassLoaders()) {
                    try {
                        clazz = cl.loadClass(currentClass);
                        classes.add(clazz);
                        continue block7;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
            }
        }
    }
}

