/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;

public enum SchemaType {
    PROTOBUF("protobuf"),
    AVRO("avsc"),
    JSON("json");

    private static final SchemaType[] VALUES;
    private final String schemaType;

    private SchemaType(String type) {
        this.schemaType = type;
    }

    public String type() {
        return this.schemaType;
    }

    public static SchemaType of(String type) {
        return Arrays.stream(VALUES).filter(s -> Objects.equals(s.schemaType, type)).findFirst().orElseGet(() -> SchemaType.valueOf(type.toUpperCase(Locale.US)));
    }

    static {
        VALUES = SchemaType.values();
    }
}

