/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote;

import org.apache.camel.Message;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanQueryBuilder;
import org.apache.camel.component.infinispan.InfinispanUtil;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteConfiguration;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteManager;
import org.apache.camel.component.infinispan.remote.embeddingstore.EmbeddingStoreUtil;
import org.apache.camel.component.infinispan.remote.embeddingstore.InfinispanVectorQueryBuilder;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.api.query.Query;

public final class InfinispanRemoteUtil
extends InfinispanUtil {
    protected InfinispanRemoteUtil() {
    }

    public static <K, V> RemoteCache<K, V> getCacheWithFlags(InfinispanRemoteManager manager, String cacheName, Flag ... flags) {
        RemoteCache cache = (RemoteCache)manager.getCache(cacheName, RemoteCache.class);
        return flags == null || flags.length == 0 ? cache : cache.withFlags(flags);
    }

    public static Query<?> buildQuery(InfinispanRemoteConfiguration configuration, RemoteCache<Object, Object> cache, Message message) {
        InfinispanQueryBuilder builder = (InfinispanQueryBuilder)message.getHeader("CamelInfinispanQueryBuilder", InfinispanQueryBuilder.class);
        if (builder == null) {
            builder = configuration.getQueryBuilder();
        }
        if (builder instanceof InfinispanVectorQueryBuilder) {
            InfinispanVectorQueryBuilder vectorQueryBuilder = (InfinispanVectorQueryBuilder)builder;
            vectorQueryBuilder.setDistance(configuration.getEmbeddingStoreDistance());
            vectorQueryBuilder.setTypeName(EmbeddingStoreUtil.getTypeName(configuration));
        }
        return InfinispanRemoteUtil.buildQuery(builder, cache);
    }

    public static Query<?> buildQuery(InfinispanConfiguration configuration, RemoteCache<Object, Object> cache) {
        return InfinispanRemoteUtil.buildQuery(configuration.getQueryBuilder(), cache);
    }

    public static Query<?> buildQuery(InfinispanQueryBuilder queryBuilder, RemoteCache<Object, Object> cache) {
        return queryBuilder != null ? queryBuilder.build(cache) : null;
    }
}

