/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote.embeddingstore;

import org.apache.camel.CamelContext;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteConfiguration;
import org.apache.camel.component.infinispan.remote.embeddingstore.InfinispanRemoteEmbeddingMarshaller;
import org.apache.camel.util.ObjectHelper;
import org.infinispan.api.annotations.indexing.option.VectorSimilarity;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.schema.Schema;
import org.infinispan.protostream.schema.Type;

public final class EmbeddingStoreUtil {
    public static final String DEFAULT_TYPE_NAME_PREFIX = "CamelInfinispanRemoteEmbedding";
    public static final String FIELD_ID = "id";
    public static final String FIELD_EMBEDDING = "embedding";
    public static final String FIELD_TEXT = "TEXT";
    public static final String FIELD_METADATA_KEYS = "metadataKeys";
    public static final String FIELD_METADATA_VALUES = "metadataValues";

    private EmbeddingStoreUtil() {
    }

    public static boolean isEmbeddingStoreEnabled(CamelContext context, InfinispanRemoteConfiguration configuration) {
        return configuration.isEmbeddingStoreEnabled() && (context.hasComponent("langchain4j-embeddings") != null || context.getCamelContextExtension().getFactoryFinder("META-INF/services/org/apache/camel/component/").findClass("langchain4j-embeddings").isPresent());
    }

    public static String getSchema(InfinispanRemoteConfiguration configuration) {
        long dimension = configuration.getEmbeddingStoreDimension();
        VectorSimilarity vectorSimilarity = configuration.getEmbeddingStoreVectorSimilarity();
        return new Schema.Builder(EmbeddingStoreUtil.getSchemeFileName(configuration)).addMessage(EmbeddingStoreUtil.getTypeName(configuration)).addComment("@Indexed").addField((Type)Type.Scalar.STRING, FIELD_ID, 1).addComment("@Text").addRepeatedField((Type)Type.Scalar.FLOAT, FIELD_EMBEDDING, 2).addComment("@Vector(dimension=" + dimension + ", similarity=" + String.valueOf(vectorSimilarity) + ")").addField((Type)Type.Scalar.STRING, FIELD_TEXT, 3).addComment("@Keyword").addRepeatedField((Type)Type.Scalar.STRING, FIELD_METADATA_KEYS, 4).addRepeatedField((Type)Type.Scalar.STRING, FIELD_METADATA_VALUES, 5).build().toString();
    }

    public static String getSchemeFileName(InfinispanRemoteConfiguration configuration) {
        return "%s.proto".formatted(EmbeddingStoreUtil.getTypeName(configuration));
    }

    public static FileDescriptorSource getSchemaFileDescriptor(InfinispanRemoteConfiguration configuration) {
        return FileDescriptorSource.fromString((String)EmbeddingStoreUtil.getSchemeFileName(configuration), (String)EmbeddingStoreUtil.getSchema(configuration));
    }

    public static void configureMarshaller(InfinispanRemoteConfiguration configuration, ConfigurationBuilder builder) {
        ProtoStreamMarshaller marshaller = new ProtoStreamMarshaller();
        SerializationContext serializationContext = marshaller.getSerializationContext();
        FileDescriptorSource fileDescriptorSource = EmbeddingStoreUtil.getSchemaFileDescriptor(configuration);
        serializationContext.registerProtoFiles(fileDescriptorSource);
        serializationContext.registerMarshaller((BaseMarshaller)new InfinispanRemoteEmbeddingMarshaller(EmbeddingStoreUtil.getTypeName(configuration)));
        builder.marshaller((Marshaller)marshaller);
    }

    public static void registerSchema(InfinispanRemoteConfiguration configuration, RemoteCacheManager cacheContainer) {
        RemoteCache metadataCache = cacheContainer.getCache("___protobuf_metadata");
        metadataCache.put((Object)EmbeddingStoreUtil.getSchemeFileName(configuration), (Object)EmbeddingStoreUtil.getSchema(configuration));
    }

    public static String getTypeName(InfinispanRemoteConfiguration configuration) {
        String embeddingStoreTypeName = configuration.getEmbeddingStoreTypeName();
        if (ObjectHelper.isEmpty((String)embeddingStoreTypeName)) {
            embeddingStoreTypeName = "%s%d".formatted(DEFAULT_TYPE_NAME_PREFIX, configuration.getEmbeddingStoreDimension());
        }
        return embeddingStoreTypeName;
    }
}

