/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote.transform;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Message;
import org.apache.camel.component.infinispan.InfinispanOperation;
import org.apache.camel.component.infinispan.InfinispanQueryBuilder;
import org.apache.camel.component.infinispan.remote.embeddingstore.InfinispanRemoteEmbedding;
import org.apache.camel.component.infinispan.remote.embeddingstore.InfinispanVectorQueryBuilder;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="infinispan:embeddings", description="Prepares the message to become an object writable by the Infinispan component")
public class InfinispanEmbeddingsDataTypeTransformer
extends Transformer {
    private static final Set<InfinispanOperation> ALLOWED_EMBEDDING_OPERATIONS = Set.of(InfinispanOperation.PUT, InfinispanOperation.PUTASYNC, InfinispanOperation.PUTIFABSENT, InfinispanOperation.PUTIFABSENTASYNC, InfinispanOperation.REPLACE, InfinispanOperation.REPLACEASYNC, InfinispanOperation.QUERY);

    public void transform(Message message, DataType from, DataType to) throws Exception {
        InfinispanOperation operation = (InfinispanOperation)message.getHeader("CamelInfinispanOperation", (Object)InfinispanOperation.PUT, InfinispanOperation.class);
        Embedding embedding = (Embedding)message.getHeader("CamelLangChain4jEmbeddingsVector", Embedding.class);
        if (ALLOWED_EMBEDDING_OPERATIONS.contains(operation) && embedding != null) {
            if (operation.equals((Object)InfinispanOperation.QUERY)) {
                InfinispanQueryBuilder builder = (InfinispanQueryBuilder)message.getHeader("CamelInfinispanQueryBuilder", InfinispanQueryBuilder.class);
                if (builder == null) {
                    message.setHeader("CamelInfinispanQueryBuilder", (Object)new InfinispanVectorQueryBuilder(embedding.vector()));
                }
            } else {
                String text = null;
                ArrayList<String> metadataKeys = null;
                ArrayList<String> metadataValues = null;
                TextSegment textSegment = (TextSegment)message.getHeader("CamelLangChain4jEmbeddingsTextSegment", TextSegment.class);
                if (textSegment != null) {
                    text = textSegment.text();
                    metadataKeys = new ArrayList<String>();
                    metadataValues = new ArrayList<String>();
                    Map metadata = textSegment.metadata().toMap();
                    for (Map.Entry entry : metadata.entrySet()) {
                        metadataKeys.add((String)entry.getKey());
                        metadataValues.add(entry.getValue().toString());
                    }
                }
                InfinispanRemoteEmbedding item = new InfinispanRemoteEmbedding(message.getMessageId(), embedding.vector(), text, metadataKeys, metadataValues);
                if (operation.equals((Object)InfinispanOperation.REPLACE) || operation.equals((Object)InfinispanOperation.REPLACEASYNC)) {
                    InfinispanRemoteEmbedding oldValue = (InfinispanRemoteEmbedding)message.getHeader("CamelInfinispanOldValue", InfinispanRemoteEmbedding.class);
                    if (oldValue != null) {
                        message.setHeader("CamelInfinispanKey", (Object)oldValue.getId());
                    }
                } else {
                    message.setHeader("CamelInfinispanKey", (Object)message.getMessageId());
                }
                message.setHeader("CamelInfinispanValue", (Object)item);
            }
        }
    }
}

