/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.embedded;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedCustomListener;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;

@UriParams
public class InfinispanEmbeddedConfiguration
extends InfinispanConfiguration
implements Cloneable {
    @Metadata(autowired=true)
    @UriParam(label="advanced")
    private Configuration cacheContainerConfiguration;
    @Metadata(autowired=true)
    @UriParam(label="advanced")
    private EmbeddedCacheManager cacheContainer;
    @UriParam(label="consumer", defaultValue="true")
    private boolean sync = true;
    @UriParam(label="consumer", defaultValue="false")
    private boolean clusteredListener;
    @UriParam(label="consumer")
    private String eventTypes;
    @UriParam(label="consumer")
    private InfinispanEmbeddedCustomListener customListener;
    @UriParam(label="advanced", javaType="java.lang.String")
    private Flag[] flags;

    public EmbeddedCacheManager getCacheContainer() {
        return this.cacheContainer;
    }

    public void setCacheContainer(EmbeddedCacheManager cacheContainer) {
        this.cacheContainer = cacheContainer;
    }

    public Configuration getCacheContainerConfiguration() {
        return this.cacheContainerConfiguration;
    }

    public void setCacheContainerConfiguration(Configuration cacheContainerConfiguration) {
        this.cacheContainerConfiguration = cacheContainerConfiguration;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean isClusteredListener() {
        return this.clusteredListener;
    }

    public void setClusteredListener(boolean clusteredListener) {
        this.clusteredListener = clusteredListener;
    }

    public String getEventTypes() {
        return this.eventTypes;
    }

    public void setEventTypes(String eventTypes) {
        this.eventTypes = eventTypes;
    }

    public InfinispanEmbeddedCustomListener getCustomListener() {
        return this.customListener;
    }

    public void setCustomListener(InfinispanEmbeddedCustomListener customListener) {
        this.customListener = customListener;
    }

    public boolean hasCustomListener() {
        return this.customListener != null;
    }

    public Flag[] getFlags() {
        return this.flags;
    }

    public void setFlags(String flagsAsString) {
        String[] flagsArray = flagsAsString.split(",");
        this.flags = new Flag[flagsArray.length];
        for (int i = 0; i < flagsArray.length; ++i) {
            this.flags[i] = Flag.valueOf((String)flagsArray[i]);
        }
    }

    public void setFlags(Flag ... flags) {
        this.flags = flags;
    }

    public boolean hasFlags() {
        return this.flags != null && this.flags.length > 0;
    }

    public InfinispanEmbeddedConfiguration clone() {
        try {
            return (InfinispanEmbeddedConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

