/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Message;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanEndpoint;
import org.apache.camel.component.infinispan.InfinispanManager;
import org.apache.camel.component.infinispan.InfinispanUtil;
import org.apache.camel.spi.InvokeOnHeader;
import org.apache.camel.support.HeaderSelectorProducer;
import org.apache.camel.util.ObjectHelper;
import org.infinispan.commons.api.BasicCache;

public abstract class InfinispanProducer<M extends InfinispanManager, C extends InfinispanConfiguration>
extends HeaderSelectorProducer {
    private final String cacheName;
    private final C configuration;
    private final M manager;

    protected InfinispanProducer(InfinispanEndpoint endpoint, String cacheName, M manager, C configuration) {
        super((Endpoint)endpoint, "CamelInfinispanOperation", ((InfinispanConfiguration)configuration).getOperationOrDefault()::name);
        this.cacheName = cacheName;
        this.configuration = configuration;
        this.manager = manager;
    }

    protected String getCacheName() {
        return this.cacheName;
    }

    protected C getConfiguration() {
        return this.configuration;
    }

    protected M getManager() {
        return this.manager;
    }

    @InvokeOnHeader(value="PUT")
    public void onPut(Message message) {
        Object result;
        BasicCache cache = this.getCache(message);
        Object key = message.getHeader("CamelInfinispanKey", () -> this.configuration.getKey());
        Object value = message.getHeader("CamelInfinispanValue", () -> this.configuration.getValue());
        if (this.hasLifespan(message)) {
            long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
            TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
            if (this.hasMaxIdleTime(message)) {
                long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                result = cache.put(key, value, lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
            } else {
                result = cache.put(key, value, lifespan, timeUnit);
            }
        } else {
            result = cache.put(key, value);
        }
        this.setResult(message, result);
    }

    @InvokeOnHeader(value="PUTASYNC")
    public void onPutAsync(Message message) {
        CompletableFuture result;
        BasicCache cache = this.getCache(message);
        Object key = message.getHeader("CamelInfinispanKey", () -> this.configuration.getKey());
        Object value = message.getHeader("CamelInfinispanValue", () -> this.configuration.getValue());
        if (this.hasLifespan(message)) {
            long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
            TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
            if (this.hasMaxIdleTime(message)) {
                long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                result = cache.putAsync(key, value, lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
            } else {
                result = cache.putAsync(key, value, lifespan, timeUnit);
            }
        } else {
            result = cache.putAsync(key, value);
        }
        this.setResult(message, result);
    }

    @InvokeOnHeader(value="PUTALL")
    public void onPutAll(Message message) {
        BasicCache cache = this.getCache(message);
        Map map = (Map)message.getHeader("CamelInfinispanMap", Map.class);
        if (this.hasLifespan(message)) {
            long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
            TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
            if (this.hasMaxIdleTime(message)) {
                long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                cache.putAll(map, lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
            } else {
                cache.putAll(map, lifespan, timeUnit);
            }
        } else {
            cache.putAll(map);
        }
    }

    @InvokeOnHeader(value="PUTALLASYNC")
    public void onPutAllAsync(Message message) {
        CompletableFuture result;
        BasicCache cache = this.getCache(message);
        Map map = (Map)message.getHeader("CamelInfinispanMap", Map.class);
        if (this.hasLifespan(message)) {
            long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
            TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
            if (this.hasMaxIdleTime(message)) {
                long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                result = cache.putAllAsync(map, lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
            } else {
                result = cache.putAllAsync(map, lifespan, timeUnit);
            }
        } else {
            result = cache.putAllAsync(map);
        }
        this.setResult(message, result);
    }

    @InvokeOnHeader(value="PUTIFABSENT")
    public void onPutIfAbsent(Message message) {
        Object result;
        BasicCache cache = this.getCache(message);
        Object key = message.getHeader("CamelInfinispanKey", () -> this.configuration.getKey());
        Object value = message.getHeader("CamelInfinispanValue", () -> this.configuration.getValue());
        if (this.hasLifespan(message)) {
            long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
            TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
            if (this.hasMaxIdleTime(message)) {
                long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                result = cache.putIfAbsent(key, value, lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
            } else {
                result = cache.putIfAbsent(key, value, lifespan, timeUnit);
            }
        } else {
            result = cache.putIfAbsent(key, value);
        }
        this.setResult(message, result);
    }

    @InvokeOnHeader(value="PUTIFABSENTASYNC")
    public void onPutIfAbsentAsync(Message message) {
        CompletableFuture result;
        BasicCache cache = this.getCache(message);
        Object key = message.getHeader("CamelInfinispanKey", () -> this.configuration.getKey());
        Object value = message.getHeader("CamelInfinispanValue", () -> this.configuration.getValue());
        if (this.hasLifespan(message)) {
            long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
            TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
            if (this.hasMaxIdleTime(message)) {
                long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                result = cache.putIfAbsentAsync(key, value, lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
            } else {
                result = cache.putIfAbsentAsync(key, value, lifespan, timeUnit);
            }
        } else {
            result = cache.putIfAbsentAsync(key, value);
        }
        this.setResult(message, result);
    }

    @InvokeOnHeader(value="GET")
    public void onGet(Message message) {
        BasicCache cache = this.getCache(message);
        Object key = message.getHeader("CamelInfinispanKey", () -> this.configuration.getKey());
        Object result = cache.get(key);
        this.setResult(message, result);
    }

    @InvokeOnHeader(value="GETORDEFAULT")
    public void onGetOrDefault(Message message) {
        BasicCache cache = this.getCache(message);
        Object key = message.getHeader("CamelInfinispanKey", () -> this.configuration.getKey());
        Object defaultValue = message.getHeader("CamelInfinispanDefaultValue", () -> this.configuration.getDefaultValue());
        Object result = cache.getOrDefault(key, defaultValue);
        this.setResult(message, result);
    }

    @InvokeOnHeader(value="CONTAINSKEY")
    public void onContainsKey(Message message) {
        BasicCache cache = this.getCache(message);
        Object key = message.getHeader("CamelInfinispanKey", () -> this.configuration.getKey());
        Boolean result = cache.containsKey(key);
        this.setResult(message, result);
    }

    @InvokeOnHeader(value="CONTAINSVALUE")
    public void onContainsValue(Message message) {
        BasicCache cache = this.getCache(message);
        Object value = message.getHeader("CamelInfinispanValue", () -> this.configuration.getValue());
        Boolean result = cache.containsValue(value);
        this.setResult(message, result);
    }

    @InvokeOnHeader(value="REMOVE")
    public void onRemove(Message message) {
        BasicCache cache = this.getCache(message);
        Object key = message.getHeader("CamelInfinispanKey", () -> this.configuration.getKey());
        Object value = message.getHeader("CamelInfinispanValue", () -> this.configuration.getValue());
        Object result = ObjectHelper.isEmpty((Object)value) ? cache.remove(key) : Boolean.valueOf(cache.remove(key, value));
        this.setResult(message, result);
    }

    @InvokeOnHeader(value="REMOVEASYNC")
    public void onRemoveAsync(Message message) {
        BasicCache cache = this.getCache(message);
        Object key = message.getHeader("CamelInfinispanKey", () -> this.configuration.getKey());
        Object value = message.getHeader("CamelInfinispanValue", () -> this.configuration.getValue());
        if (ObjectHelper.isEmpty((Object)value)) {
            CompletableFuture resultRemoveAsyncKey = cache.removeAsync(key);
            this.setResult(message, resultRemoveAsyncKey);
        } else {
            CompletableFuture resultRemoveAsyncKeyValue = cache.removeAsync(key, value);
            this.setResult(message, resultRemoveAsyncKeyValue);
        }
    }

    @InvokeOnHeader(value="REPLACE")
    public void onReplace(Message message) {
        Object result;
        BasicCache cache = this.getCache(message);
        Object key = message.getHeader("CamelInfinispanKey", () -> this.configuration.getKey());
        Object value = message.getHeader("CamelInfinispanValue", () -> this.configuration.getValue());
        Object oldValue = message.getHeader("CamelInfinispanOldValue", () -> this.configuration.getOldValue());
        if (this.hasLifespan(message)) {
            long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
            TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
            if (this.hasMaxIdleTime(message)) {
                long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                result = ObjectHelper.isEmpty((Object)oldValue) ? cache.replace(key, value, lifespan, timeUnit, maxIdle, maxIdleTimeUnit) : Boolean.valueOf(cache.replace(key, oldValue, value, lifespan, timeUnit, maxIdle, maxIdleTimeUnit));
            } else {
                result = ObjectHelper.isEmpty((Object)oldValue) ? cache.replace(key, value, lifespan, timeUnit) : Boolean.valueOf(cache.replace(key, oldValue, value, lifespan, timeUnit));
            }
        } else {
            result = ObjectHelper.isEmpty((Object)oldValue) ? cache.replace(key, value) : Boolean.valueOf(cache.replace(key, oldValue, value));
        }
        this.setResult(message, result);
    }

    @InvokeOnHeader(value="REPLACEASYNC")
    public void onReplaceAsync(Message message) {
        BasicCache cache = this.getCache(message);
        Object key = message.getHeader("CamelInfinispanKey", () -> this.configuration.getKey());
        Object value = message.getHeader("CamelInfinispanValue", () -> this.configuration.getValue());
        Object oldValue = message.getHeader("CamelInfinispanOldValue", () -> this.configuration.getOldValue());
        if (this.hasLifespan(message)) {
            long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
            TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
            if (this.hasMaxIdleTime(message)) {
                long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                if (ObjectHelper.isEmpty((Object)oldValue)) {
                    CompletableFuture resultWithNewValue = cache.replaceAsync(key, value, lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
                    this.setResult(message, resultWithNewValue);
                } else {
                    CompletableFuture resultWithNewAndOldValue = cache.replaceAsync(key, oldValue, value, lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
                    this.setResult(message, resultWithNewAndOldValue);
                }
            } else if (ObjectHelper.isEmpty((Object)oldValue)) {
                CompletableFuture resultWithNewValue = cache.replaceAsync(key, value, lifespan, timeUnit);
                this.setResult(message, resultWithNewValue);
            } else {
                CompletableFuture resultWithNewAndOldValue = cache.replaceAsync(key, oldValue, value, lifespan, timeUnit);
                this.setResult(message, resultWithNewAndOldValue);
            }
        } else if (ObjectHelper.isEmpty((Object)oldValue)) {
            CompletableFuture resultWithNewValue = cache.replaceAsync(key, value);
            this.setResult(message, resultWithNewValue);
        } else {
            CompletableFuture resultWithNewAndOldValue = cache.replaceAsync(key, oldValue, value);
            this.setResult(message, resultWithNewAndOldValue);
        }
    }

    @InvokeOnHeader(value="SIZE")
    public void onSize(Message message) {
        BasicCache cache = this.getCache(message);
        Integer result = cache.size();
        this.setResult(message, result);
    }

    @InvokeOnHeader(value="CLEAR")
    public void onClear(Message message) {
        BasicCache cache = this.getCache(message);
        cache.clear();
    }

    @InvokeOnHeader(value="CLEARASYNC")
    public void onCLearAsync(Message message) {
        BasicCache cache = this.getCache(message);
        CompletableFuture result = cache.clearAsync();
        this.setResult(message, result);
    }

    @InvokeOnHeader(value="COMPUTE")
    public void onCompute(Message message) {
        BasicCache cache = this.getCache(message);
        Object key = message.getHeader("CamelInfinispanKey", () -> this.configuration.getKey());
        Object result = cache.compute(key, ((InfinispanConfiguration)this.configuration).getRemappingFunction());
        this.setResult(message, result);
    }

    @InvokeOnHeader(value="COMPUTEASYNC")
    public void onComputeAsync(Message message) {
        BasicCache cache = this.getCache(message);
        Object key = message.getHeader("CamelInfinispanKey", () -> this.configuration.getKey());
        CompletableFuture result = cache.computeAsync(key, ((InfinispanConfiguration)this.configuration).getRemappingFunction());
        this.setResult(message, result);
    }

    protected <K, V> BasicCache<K, V> getCache(Message message) {
        return this.manager.getCache(message, this.cacheName);
    }

    protected boolean hasLifespan(Message message) {
        return !InfinispanUtil.isHeaderEmpty(message, "CamelInfinispanLifespanTime") && !InfinispanUtil.isHeaderEmpty(message, "CamelInfinispanTimeUnit");
    }

    protected boolean hasMaxIdleTime(Message message) {
        return !InfinispanUtil.isHeaderEmpty(message, "CamelInfinispanMaxIdleTime") && !InfinispanUtil.isHeaderEmpty(message, "CamelInfinispanMaxIdleTimeUnit");
    }

    protected void setResult(Message message, Object result) {
        String resultHeader = (String)message.getHeader("CamelInfinispanOperationResultHeader", () -> this.configuration.getResultHeader(), String.class);
        if (resultHeader != null) {
            message.setHeader(resultHeader, result);
        } else {
            message.setBody(result);
        }
    }
}

