/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite;

import java.util.Collection;
import org.apache.camel.Component;
import org.apache.camel.component.ignite.AbstractIgniteComponent;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.ignite.Ignite;

public abstract class AbstractIgniteEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    @UriParam(defaultValue="true")
    private boolean propagateIncomingBodyIfNoReturnValue = true;
    @UriParam
    private boolean treatCollectionsAsCacheObjects;

    public AbstractIgniteEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public String getServiceUrl() {
        Collection a = this.ignite().cluster().localNode().addresses();
        if (!a.isEmpty()) {
            return (String)a.iterator().next();
        }
        return null;
    }

    public String getServiceProtocol() {
        return "ignite";
    }

    protected AbstractIgniteComponent igniteComponent() {
        return (AbstractIgniteComponent)this.getComponent();
    }

    protected Ignite ignite() {
        return this.igniteComponent().getIgnite();
    }

    public boolean isPropagateIncomingBodyIfNoReturnValue() {
        return this.propagateIncomingBodyIfNoReturnValue;
    }

    public void setPropagateIncomingBodyIfNoReturnValue(boolean propagateIncomingBodyIfNoReturnValue) {
        this.propagateIncomingBodyIfNoReturnValue = propagateIncomingBodyIfNoReturnValue;
    }

    public boolean isTreatCollectionsAsCacheObjects() {
        return this.treatCollectionsAsCacheObjects;
    }

    public void setTreatCollectionsAsCacheObjects(boolean treatCollectionsAsCacheObjects) {
        this.treatCollectionsAsCacheObjects = treatCollectionsAsCacheObjects;
    }
}

