/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ical;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.Date;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.property.DateProperty;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.support.ExchangeHelper;

@Converter(generateLoader=true)
public final class ICalConverter {
    private ICalConverter() {
    }

    @Converter
    public static Date toDate(DateProperty property) {
        Temporal t = property.getDate();
        if (t instanceof Instant) {
            Instant ins = (Instant)t;
            return Date.from(ins);
        }
        return null;
    }

    @Converter
    public static Instant toInstant(DateProperty property) {
        Temporal t = property.getDate();
        if (t instanceof Instant) {
            Instant ins = (Instant)t;
            return ins;
        }
        return null;
    }

    @Converter
    public static ByteArrayInputStream toStream(Calendar calendar, Exchange exchange) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(calendar.toString().getBytes(ExchangeHelper.getCharsetName((Exchange)exchange)));
    }
}

