/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ibm.watson.language;

import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.IamAuthenticator;
import com.ibm.watson.natural_language_understanding.v1.NaturalLanguageUnderstanding;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ibm.watson.language.WatsonLanguageComponent;
import org.apache.camel.component.ibm.watson.language.WatsonLanguageConfiguration;
import org.apache.camel.component.ibm.watson.language.WatsonLanguageConstants;
import org.apache.camel.component.ibm.watson.language.WatsonLanguageProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="4.16.0", scheme="ibm-watson-language", title="IBM Watson Language", syntax="ibm-watson-language:label", producerOnly=true, category={Category.AI, Category.CLOUD}, headersClass=WatsonLanguageConstants.class)
public class WatsonLanguageEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    @UriPath(description="Logical name")
    @Metadata(required=true)
    private String label;
    @UriParam
    private WatsonLanguageConfiguration configuration;
    private NaturalLanguageUnderstanding nluClient;

    public WatsonLanguageEndpoint(String uri, WatsonLanguageComponent component, WatsonLanguageConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new WatsonLanguageProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported for IBM Watson Language");
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.configuration.getApiKey() == null) {
            throw new IllegalArgumentException("API key is required");
        }
        this.nluClient = this.createNluClient();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.nluClient = null;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public WatsonLanguageConfiguration getConfiguration() {
        return this.configuration;
    }

    public NaturalLanguageUnderstanding getNluClient() {
        return this.nluClient;
    }

    public String getServiceUrl() {
        return this.configuration.getServiceUrl();
    }

    public String getServiceProtocol() {
        return "https";
    }

    private NaturalLanguageUnderstanding createNluClient() {
        IamAuthenticator authenticator = new IamAuthenticator(this.configuration.getApiKey());
        NaturalLanguageUnderstanding service = new NaturalLanguageUnderstanding("2022-04-07", (Authenticator)authenticator);
        if (this.configuration.getServiceUrl() != null) {
            service.setServiceUrl(this.configuration.getServiceUrl());
        }
        return service;
    }
}

