/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ibm.secrets.manager.vault;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.ibm.secrets.manager.IBMSecretsManagerPropertiesFunction;
import org.apache.camel.spi.ContextReloadStrategy;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.spi.annotations.PeriodicTask;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.vault.IBMSecretsManagerVaultConfiguration;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PeriodicTask(value="ibm-secret-refresh")
public class IBMEventStreamReloadTriggerTask
extends ServiceSupport
implements CamelContextAware,
Runnable {
    private static final String CAMEL_VAULT_IBM_EVENTSTREAM_BOOTSTRAP_SERVERS_ENV = "CAMEL_VAULT_IBM_EVENTSTREAM_BOOTSTRAP_SERVERS";
    private static final String CAMEL_VAULT_IBM_EVENTSTREAM_TOPIC_ENV = "CAMEL_VAULT_IBM_EVENTSTREAM_TOPIC";
    private static final String CAMEL_VAULT_IBM_EVENTSTREAM_USERNAME_ENV = "CAMEL_VAULT_IBM_EVENTSTREAM_USERNAME";
    private static final String CAMEL_VAULT_IBM_EVENTSTREAM_PASSWORD_ENV = "CAMEL_VAULT_IBM_EVENTSTREAM_PASSWORD";
    private static final String CAMEL_VAULT_IBM_EVENTSTREAM_CONSUMER_GROUPID_ENV = "CAMEL_VAULT_IBM_EVENTSTREAM_CONSUMER_GROUP_ID";
    private static final String CAMEL_VAULT_IBM_EVENTSTREAM_CONSUMER_POLL_TIMEOUT_ENV = "CAMEL_VAULT_IBM_EVENTSTREAM_CONSUMER_POLL_TIMEOUT";
    private CamelContext camelContext;
    private boolean reloadEnabled = true;
    private String secrets;
    private IBMSecretsManagerPropertiesFunction propertiesFunction;
    private volatile Instant lastTime;
    private volatile Instant lastCheckTime;
    private volatile Instant lastReloadTime;
    private final Map<String, Instant> updates = new HashMap<String, Instant>();
    KafkaConsumer<String, String> kafkaConsumer;
    private static final String IBM_SECRETS_MANAGER_SECRET_ROTATED_EVENT = "secret_rotated";
    protected long pollTimeout;
    private static final Logger LOG = LoggerFactory.getLogger(IBMEventStreamReloadTriggerTask.class);

    protected void doStart() throws Exception {
        super.doStart();
        PropertiesComponent pc = this.camelContext.getPropertiesComponent();
        PropertiesFunction pf = pc.getPropertiesFunction("ibm");
        if (pf instanceof IBMSecretsManagerPropertiesFunction) {
            this.propertiesFunction = (IBMSecretsManagerPropertiesFunction)pf;
            LOG.debug("Auto-detecting secrets from properties-function: {}", (Object)pf.getName());
        }
        this.secrets = this.camelContext.getVaultConfiguration().ibmSecretsManager().getSecrets();
        if (ObjectHelper.isEmpty((String)this.secrets) && this.propertiesFunction == null) {
            throw new IllegalArgumentException("Secrets must be configured on IBM vault configuration");
        }
        String bootstrapServers = System.getenv(CAMEL_VAULT_IBM_EVENTSTREAM_BOOTSTRAP_SERVERS_ENV);
        String groupId = System.getenv(CAMEL_VAULT_IBM_EVENTSTREAM_CONSUMER_GROUPID_ENV);
        String topic = System.getenv(CAMEL_VAULT_IBM_EVENTSTREAM_TOPIC_ENV);
        String username = System.getenv(CAMEL_VAULT_IBM_EVENTSTREAM_USERNAME_ENV);
        String password = System.getenv(CAMEL_VAULT_IBM_EVENTSTREAM_PASSWORD_ENV);
        this.pollTimeout = ObjectHelper.isNotEmpty((String)System.getenv(CAMEL_VAULT_IBM_EVENTSTREAM_CONSUMER_POLL_TIMEOUT_ENV)) ? Long.parseLong(System.getenv(CAMEL_VAULT_IBM_EVENTSTREAM_CONSUMER_POLL_TIMEOUT_ENV)) : this.getCamelContext().getVaultConfiguration().getIBMSecretsManagerVaultConfiguration().getEventStreamConsumerPollTimeout();
        if (ObjectHelper.isEmpty((String)bootstrapServers) && ObjectHelper.isEmpty((String)groupId) && ObjectHelper.isEmpty((String)topic) && ObjectHelper.isEmpty((String)password)) {
            IBMSecretsManagerVaultConfiguration ibmVaultConfiguration = this.getCamelContext().getVaultConfiguration().ibmSecretsManager();
            if (ObjectHelper.isNotEmpty((Object)ibmVaultConfiguration)) {
                bootstrapServers = ibmVaultConfiguration.getEventStreamBootstrapServers();
                groupId = ibmVaultConfiguration.getEventStreamGroupId();
                topic = ibmVaultConfiguration.getEventStreamTopic();
                if (ObjectHelper.isEmpty((String)username)) {
                    username = ObjectHelper.isNotEmpty((String)ibmVaultConfiguration.getEventStreamUsername()) ? ibmVaultConfiguration.getEventStreamUsername() : "token";
                }
                password = ibmVaultConfiguration.getEventStreamPassword();
            }
        } else {
            throw new RuntimeCamelException("Using the IBM Secrets Refresh Task requires setting IBM Event Stream bootstrap servers, topic, groupId, username and password as application properties or environment variables");
        }
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("bootstrap.servers", bootstrapServers);
        configs.put("key.deserializer", StringDeserializer.class);
        configs.put("value.deserializer", StringDeserializer.class);
        configs.put("group.id", groupId);
        configs.put("auto.offset.reset", "latest");
        configs.put("enable.auto.commit", "true");
        configs.put("security.protocol", "SASL_SSL");
        configs.put("sasl.mechanism", "PLAIN");
        configs.put("sasl.jaas.config", "org.apache.kafka.common.security.plain.PlainLoginModule required username=" + username + " password=" + password + ";");
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.kafkaConsumer = new KafkaConsumer(configs);
        this.kafkaConsumer.subscribe(Arrays.asList(topic));
    }

    @Override
    public void run() {
        this.lastCheckTime = Instant.now();
        boolean triggerReloading = false;
        ObjectMapper mapper = new ObjectMapper();
        block2: while (true) {
            ConsumerRecords records = this.kafkaConsumer.poll(Duration.ofMillis(this.pollTimeout));
            Iterator iterator = records.iterator();
            block3: while (true) {
                String name;
                JsonNode secret;
                String secretType;
                JsonNode recordJson;
                if (!iterator.hasNext()) continue block2;
                ConsumerRecord record = (ConsumerRecord)iterator.next();
                try {
                    recordJson = mapper.readTree((String)record.value());
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
                JsonNode payload = recordJson.get("data");
                if (payload == null || (secretType = payload.get("event_type").asText()) == null || !secretType.equalsIgnoreCase(IBM_SECRETS_MANAGER_SECRET_ROTATED_EVENT)) continue;
                ArrayNode secretsRotated = (ArrayNode)payload.get("secrets");
                Iterator iterator2 = secretsRotated.iterator();
                do {
                    if (!iterator2.hasNext()) continue block3;
                } while ((secret = (JsonNode)iterator2.next()) == null || !this.matchSecret(name = secret.get("secret_name").asText()));
                this.updates.put(name, Instant.parse(secret.get("event_time").asText()));
                if (this.isReloadEnabled()) {
                    LOG.info("Update for IBM secret: {} detected, triggering CamelContext reload", (Object)name);
                    triggerReloading = true;
                }
                if (!triggerReloading) continue;
                ContextReloadStrategy reload = (ContextReloadStrategy)this.camelContext.hasService(ContextReloadStrategy.class);
                if (reload != null) {
                    this.lastReloadTime = Instant.now();
                    reload.onReload((Object)this);
                }
                triggerReloading = false;
            }
            break;
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void setReloadEnabled(boolean reloadEnabled) {
        this.reloadEnabled = reloadEnabled;
    }

    public Map<String, Instant> getUpdates() {
        return Collections.unmodifiableMap(this.updates);
    }

    public Instant getLastCheckTime() {
        return this.lastCheckTime;
    }

    public Instant getLastReloadTime() {
        return this.lastReloadTime;
    }

    public boolean isReloadEnabled() {
        return this.reloadEnabled;
    }

    protected boolean matchSecret(String name) {
        HashSet<String> set = new HashSet<String>();
        if (this.secrets != null) {
            Collections.addAll(set, this.secrets.split(","));
        }
        if (this.propertiesFunction != null) {
            set.addAll(this.propertiesFunction.getSecrets());
        }
        for (String part : set) {
            boolean result = name.contains(part) || PatternHelper.matchPattern((String)name, (String)part);
            LOG.trace("Matching secret id: {}={} -> {}", new Object[]{name, part, result});
            if (!result) continue;
            return true;
        }
        return false;
    }
}

