/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ibm.secrets.manager;

import com.ibm.cloud.sdk.core.http.Response;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.IamAuthenticator;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.SecretsManager;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.GetSecretByNameTypeOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.GetSecretVersionOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.Secret;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretVersion;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.annotations.PropertiesFunction;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.vault.IBMSecretsManagerVaultConfiguration;

@PropertiesFunction(value="ibm")
public class IBMSecretsManagerPropertiesFunction
extends ServiceSupport
implements org.apache.camel.spi.PropertiesFunction,
CamelContextAware {
    private static final String CAMEL_VAULT_IBM_TOKEN_ENV = "CAMEL_VAULT_IBM_TOKEN";
    private static final String CAMEL_VAULT_IBM_SERVICE_URL_ENV = "CAMEL_VAULT_IBM_SERVICE_URL";
    private CamelContext camelContext;
    private SecretsManager client;
    private String secretGroup;
    private final Set<String> secrets = new HashSet<String>();

    public IBMSecretsManagerPropertiesFunction() {
    }

    public IBMSecretsManagerPropertiesFunction(SecretsManager client) {
        this.client = client;
    }

    protected void doStart() throws Exception {
        super.doStart();
        String token = System.getenv(CAMEL_VAULT_IBM_TOKEN_ENV);
        String serviceUrl = System.getenv(CAMEL_VAULT_IBM_SERVICE_URL_ENV);
        if (ObjectHelper.isEmpty((String)token) && ObjectHelper.isEmpty((String)serviceUrl)) {
            IBMSecretsManagerVaultConfiguration ibmVaultConfiguration = this.getCamelContext().getVaultConfiguration().ibmSecretsManager();
            if (ObjectHelper.isNotEmpty((Object)ibmVaultConfiguration)) {
                token = ibmVaultConfiguration.getToken();
                serviceUrl = ibmVaultConfiguration.getServiceUrl();
            }
        } else {
            throw new RuntimeCamelException("Using the IBM Secrets Manager Properties Function requires setting IBM Credentials and service url as application properties or environment variables");
        }
        IamAuthenticator iamAuthenticator = new IamAuthenticator.Builder().apikey(token).build();
        this.client = new SecretsManager("Camel Secrets Manager Service for Properties", (Authenticator)iamAuthenticator);
        this.client.setServiceUrl(serviceUrl);
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            this.client = null;
        }
        this.secrets.clear();
        super.doStop();
    }

    public String getName() {
        return "ibm";
    }

    public String apply(String remainder) {
        String key = remainder;
        String subkey = null;
        String returnValue = null;
        String defaultValue = null;
        String version = null;
        if (remainder.contains("#")) {
            String keyRemainder = StringHelper.before((String)remainder, (String)"#");
            this.secretGroup = StringHelper.before((String)keyRemainder, (String)":");
            key = StringHelper.after((String)keyRemainder, (String)":");
            subkey = StringHelper.after((String)remainder, (String)"#");
            defaultValue = StringHelper.after((String)subkey, (String)":");
            if (ObjectHelper.isNotEmpty((String)defaultValue) && defaultValue.contains("@")) {
                version = StringHelper.after((String)defaultValue, (String)"@");
                defaultValue = StringHelper.before((String)defaultValue, (String)"@");
            }
            if (subkey.contains(":")) {
                subkey = StringHelper.before((String)subkey, (String)":");
            }
            if (subkey.contains("@")) {
                version = StringHelper.after((String)subkey, (String)"@");
                subkey = StringHelper.before((String)subkey, (String)"@");
            }
        } else if (remainder.contains(":")) {
            this.secretGroup = StringHelper.before((String)remainder, (String)":");
            key = StringHelper.after((String)remainder, (String)":");
            if (key.contains(":")) {
                defaultValue = StringHelper.after((String)key, (String)":");
                if (ObjectHelper.isNotEmpty((String)defaultValue) && defaultValue.contains("@")) {
                    version = StringHelper.after((String)defaultValue, (String)"@");
                    defaultValue = StringHelper.before((String)defaultValue, (String)"@");
                }
                if (key.contains(":")) {
                    key = StringHelper.before((String)key, (String)":");
                }
                if (key.contains("@")) {
                    version = StringHelper.after((String)key, (String)"@");
                    key = StringHelper.before((String)key, (String)"@");
                }
            } else if (key.contains("@")) {
                version = StringHelper.after((String)key, (String)"@");
                key = StringHelper.before((String)key, (String)"@");
            }
        }
        if (key != null) {
            try {
                returnValue = this.getSecretFromSource(key, subkey, defaultValue, version);
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Something went wrong while recovering " + key + " from vault");
            }
        }
        return returnValue;
    }

    private String getSecretFromSource(String key, String subkey, String defaultValue, String version) {
        this.secrets.add(key);
        String returnValue = "";
        try {
            Map data = Map.of();
            if (ObjectHelper.isNotEmpty((String)subkey)) {
                GetSecretByNameTypeOptions.Builder secretRequestBuilder = new GetSecretByNameTypeOptions.Builder();
                secretRequestBuilder.secretType("kv").name(key);
                secretRequestBuilder.secretGroupName(this.secretGroup);
                Response response = this.client.getSecretByNameType(secretRequestBuilder.build()).execute();
                data = ((Secret)response.getResult()).getData();
                if (ObjectHelper.isNotEmpty((String)version)) {
                    GetSecretVersionOptions getSecretVersionOptions = new GetSecretVersionOptions.Builder().secretId(((Secret)response.getResult()).getId()).id(version).build();
                    Response secVersion = this.client.getSecretVersion(getSecretVersionOptions).execute();
                    data = ((SecretVersion)secVersion.getResult()).getData();
                }
                if (ObjectHelper.isNotEmpty((Map)data)) {
                    data = ((Secret)response.getResult()).getData();
                }
                if (ObjectHelper.isEmpty((String)(returnValue = ObjectHelper.isNotEmpty((String)subkey) ? String.valueOf(data.get(subkey)) : null))) {
                    returnValue = defaultValue;
                }
            } else {
                GetSecretByNameTypeOptions.Builder secretRequestBuilder = new GetSecretByNameTypeOptions.Builder();
                secretRequestBuilder.secretType("arbitrary").name(key);
                secretRequestBuilder.secretGroupName(this.secretGroup);
                Response response = this.client.getSecretByNameType(secretRequestBuilder.build()).execute();
                String payload = ((Secret)response.getResult()).getPayload();
                if (ObjectHelper.isNotEmpty((String)version)) {
                    GetSecretVersionOptions getSecretVersionOptions = new GetSecretVersionOptions.Builder().secretId(((Secret)response.getResult()).getId()).id(version).build();
                    Response secVersion = this.client.getSecretVersion(getSecretVersionOptions).execute();
                    payload = ((SecretVersion)secVersion.getResult()).getPayload();
                }
                if (ObjectHelper.isEmpty((String)(returnValue = ObjectHelper.isNotEmpty((String)payload) ? payload : null))) {
                    returnValue = defaultValue;
                }
            }
        }
        catch (Exception ex) {
            if (ObjectHelper.isNotEmpty((String)defaultValue)) {
                returnValue = defaultValue;
            }
            throw ex;
        }
        return returnValue;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Set<String> getSecrets() {
        return this.secrets;
    }
}

