/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hystrix.processor;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.component.hystrix.processor.HystrixProcessor;
import org.apache.camel.model.CircuitBreakerDefinition;
import org.apache.camel.model.HystrixConfigurationDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.function.Suppliers;
import org.apache.camel.util.function.ThrowingSupplier;

public class HystrixReifier
extends ProcessorReifier<CircuitBreakerDefinition> {
    public HystrixReifier(RouteContext routeContext, CircuitBreakerDefinition definition) {
        super(routeContext, (ProcessorDefinition)definition);
    }

    public Processor createProcessor() throws Exception {
        boolean fallbackViaNetwork;
        Processor processor = this.createChildProcessor(true);
        Processor fallback = null;
        if (((CircuitBreakerDefinition)this.definition).getOnFallback() != null) {
            fallback = ProcessorReifier.reifier((RouteContext)this.routeContext, (ProcessorDefinition)((CircuitBreakerDefinition)this.definition).getOnFallback()).createProcessor();
        }
        HystrixConfigurationDefinition config = this.buildHystrixConfiguration();
        String id = this.getId((OptionalIdentifiedDefinition)this.definition, this.routeContext);
        String groupKey = config.getGroupKey();
        String threadPoolKey = config.getThreadPoolKey();
        if (groupKey == null) {
            groupKey = "CamelHystrix";
        }
        if (threadPoolKey == null) {
            threadPoolKey = groupKey;
        }
        HystrixCommandKey hcCommandKey = HystrixCommandKey.Factory.asKey((String)id);
        HystrixCommandKey hcFallbackCommandKey = HystrixCommandKey.Factory.asKey((String)(id + "-fallback"));
        HystrixCommandGroupKey hcGroupKey = HystrixCommandGroupKey.Factory.asKey((String)groupKey);
        HystrixThreadPoolKey tpKey = HystrixThreadPoolKey.Factory.asKey((String)threadPoolKey);
        HystrixCommand.Setter setter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)hcGroupKey).andCommandKey(hcCommandKey).andThreadPoolKey(tpKey);
        HystrixCommandProperties.Setter commandSetter = HystrixCommandProperties.Setter();
        setter.andCommandPropertiesDefaults(commandSetter);
        HystrixThreadPoolProperties.Setter threadPoolSetter = HystrixThreadPoolProperties.Setter();
        setter.andThreadPoolPropertiesDefaults(threadPoolSetter);
        this.configureHystrix(commandSetter, threadPoolSetter, config);
        HystrixCommand.Setter fallbackSetter = null;
        boolean bl = fallbackViaNetwork = ((CircuitBreakerDefinition)this.definition).getOnFallback() != null && this.parseBoolean(((CircuitBreakerDefinition)this.definition).getOnFallback().getFallbackViaNetwork(), false);
        if (fallbackViaNetwork) {
            HystrixThreadPoolKey tpFallbackKey = HystrixThreadPoolKey.Factory.asKey((String)(threadPoolKey + "-fallback"));
            fallbackSetter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)hcGroupKey).andCommandKey(hcFallbackCommandKey).andThreadPoolKey(tpFallbackKey);
            HystrixCommandProperties.Setter commandFallbackSetter = HystrixCommandProperties.Setter();
            fallbackSetter.andCommandPropertiesDefaults(commandFallbackSetter);
            HystrixThreadPoolProperties.Setter fallbackThreadPoolSetter = HystrixThreadPoolProperties.Setter();
            fallbackSetter.andThreadPoolPropertiesDefaults(fallbackThreadPoolSetter);
            this.configureHystrix(commandFallbackSetter, fallbackThreadPoolSetter, config);
        }
        return new HystrixProcessor(hcGroupKey, hcCommandKey, hcFallbackCommandKey, setter, fallbackSetter, processor, fallback, fallbackViaNetwork);
    }

    private void configureHystrix(HystrixCommandProperties.Setter command, HystrixThreadPoolProperties.Setter threadPool, HystrixConfigurationDefinition config) {
        if (config.getCircuitBreakerEnabled() != null) {
            command.withCircuitBreakerEnabled(Boolean.parseBoolean(config.getCircuitBreakerEnabled()));
        }
        if (config.getCircuitBreakerErrorThresholdPercentage() != null) {
            command.withCircuitBreakerErrorThresholdPercentage(Integer.parseInt(config.getCircuitBreakerErrorThresholdPercentage()));
        }
        if (config.getCircuitBreakerForceClosed() != null) {
            command.withCircuitBreakerForceClosed(Boolean.parseBoolean(config.getCircuitBreakerForceClosed()));
        }
        if (config.getCircuitBreakerForceOpen() != null) {
            command.withCircuitBreakerForceOpen(Boolean.parseBoolean(config.getCircuitBreakerForceOpen()));
        }
        if (config.getCircuitBreakerRequestVolumeThreshold() != null) {
            command.withCircuitBreakerRequestVolumeThreshold(Integer.parseInt(config.getCircuitBreakerRequestVolumeThreshold()));
        }
        if (config.getCircuitBreakerSleepWindowInMilliseconds() != null) {
            command.withCircuitBreakerSleepWindowInMilliseconds(Integer.parseInt(config.getCircuitBreakerSleepWindowInMilliseconds()));
        }
        if (config.getExecutionIsolationSemaphoreMaxConcurrentRequests() != null) {
            command.withExecutionIsolationSemaphoreMaxConcurrentRequests(Integer.parseInt(config.getExecutionIsolationSemaphoreMaxConcurrentRequests()));
        }
        if (config.getExecutionIsolationStrategy() != null) {
            command.withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.valueOf((String)config.getExecutionIsolationStrategy()));
        }
        if (config.getExecutionIsolationThreadInterruptOnTimeout() != null) {
            command.withExecutionIsolationThreadInterruptOnTimeout(Boolean.parseBoolean(config.getExecutionIsolationThreadInterruptOnTimeout()));
        }
        if (config.getExecutionTimeoutInMilliseconds() != null) {
            command.withExecutionTimeoutInMilliseconds(Integer.parseInt(config.getExecutionTimeoutInMilliseconds()));
        }
        if (config.getExecutionTimeoutEnabled() != null) {
            command.withExecutionTimeoutEnabled(Boolean.parseBoolean(config.getExecutionTimeoutEnabled()));
        }
        if (config.getFallbackIsolationSemaphoreMaxConcurrentRequests() != null) {
            command.withFallbackIsolationSemaphoreMaxConcurrentRequests(Integer.parseInt(config.getFallbackIsolationSemaphoreMaxConcurrentRequests()));
        }
        if (config.getFallbackEnabled() != null) {
            command.withFallbackEnabled(Boolean.parseBoolean(config.getFallbackEnabled()));
        }
        if (config.getMetricsHealthSnapshotIntervalInMilliseconds() != null) {
            command.withMetricsHealthSnapshotIntervalInMilliseconds(Integer.parseInt(config.getMetricsHealthSnapshotIntervalInMilliseconds()));
        }
        if (config.getMetricsRollingPercentileBucketSize() != null) {
            command.withMetricsRollingPercentileBucketSize(Integer.parseInt(config.getMetricsRollingPercentileBucketSize()));
        }
        if (config.getMetricsRollingPercentileEnabled() != null) {
            command.withMetricsRollingPercentileEnabled(Boolean.parseBoolean(config.getMetricsRollingPercentileEnabled()));
        }
        if (config.getMetricsRollingPercentileWindowInMilliseconds() != null) {
            command.withMetricsRollingPercentileWindowInMilliseconds(Integer.parseInt(config.getMetricsRollingPercentileWindowInMilliseconds()));
        }
        if (config.getMetricsRollingPercentileWindowBuckets() != null) {
            command.withMetricsRollingPercentileWindowBuckets(Integer.parseInt(config.getMetricsRollingPercentileWindowBuckets()));
        }
        if (config.getMetricsRollingStatisticalWindowInMilliseconds() != null) {
            command.withMetricsRollingStatisticalWindowInMilliseconds(Integer.parseInt(config.getMetricsRollingStatisticalWindowInMilliseconds()));
        }
        if (config.getMetricsRollingStatisticalWindowBuckets() != null) {
            command.withMetricsRollingStatisticalWindowBuckets(Integer.parseInt(config.getMetricsRollingStatisticalWindowBuckets()));
        }
        if (config.getRequestLogEnabled() != null) {
            command.withRequestLogEnabled(Boolean.parseBoolean(config.getRequestLogEnabled()));
        }
        if (config.getCorePoolSize() != null) {
            threadPool.withCoreSize(Integer.parseInt(config.getCorePoolSize()));
        }
        if (config.getMaximumSize() != null) {
            threadPool.withMaximumSize(Integer.parseInt(config.getMaximumSize()));
        }
        if (config.getKeepAliveTime() != null) {
            threadPool.withKeepAliveTimeMinutes(Integer.parseInt(config.getKeepAliveTime()));
        }
        if (config.getMaxQueueSize() != null) {
            threadPool.withMaxQueueSize(Integer.parseInt(config.getMaxQueueSize()));
        }
        if (config.getQueueSizeRejectionThreshold() != null) {
            threadPool.withQueueSizeRejectionThreshold(Integer.parseInt(config.getQueueSizeRejectionThreshold()));
        }
        if (config.getThreadPoolRollingNumberStatisticalWindowInMilliseconds() != null) {
            threadPool.withMetricsRollingStatisticalWindowInMilliseconds(Integer.parseInt(config.getThreadPoolRollingNumberStatisticalWindowInMilliseconds()));
        }
        if (config.getThreadPoolRollingNumberStatisticalWindowBuckets() != null) {
            threadPool.withMetricsRollingStatisticalWindowBuckets(Integer.parseInt(config.getThreadPoolRollingNumberStatisticalWindowBuckets()));
        }
        if (config.getAllowMaximumSizeToDivergeFromCoreSize() != null) {
            threadPool.withAllowMaximumSizeToDivergeFromCoreSize(Boolean.parseBoolean(config.getAllowMaximumSizeToDivergeFromCoreSize()));
        }
    }

    HystrixConfigurationDefinition buildHystrixConfiguration() throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.loadProperties(this.camelContext, properties, Suppliers.firstNotNull((ThrowingSupplier[])new ThrowingSupplier[]{() -> ((Model)this.camelContext.getExtension(Model.class)).getHystrixConfiguration(null), () -> (HystrixConfigurationDefinition)CamelContextHelper.lookup((CamelContext)this.camelContext, (String)"hystrix-configuration", HystrixConfigurationDefinition.class)}));
        if (((CircuitBreakerDefinition)this.definition).getConfigurationRef() != null) {
            String ref = this.parseString(((CircuitBreakerDefinition)this.definition).getConfigurationRef());
            this.loadProperties(this.camelContext, properties, Suppliers.firstNotNull((ThrowingSupplier[])new ThrowingSupplier[]{() -> ((Model)this.camelContext.getExtension(Model.class)).getHystrixConfiguration(ref), () -> (HystrixConfigurationDefinition)CamelContextHelper.mandatoryLookup((CamelContext)this.camelContext, (String)ref, HystrixConfigurationDefinition.class)}));
        }
        this.loadProperties(this.camelContext, properties, Optional.ofNullable(((CircuitBreakerDefinition)this.definition).getHystrixConfiguration()));
        BeanIntrospection beanIntrospection = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getBeanIntrospection();
        beanIntrospection.getProperties((Object)this.definition, properties, null, false);
        HystrixConfigurationDefinition config = new HystrixConfigurationDefinition();
        PropertyBindingSupport.bindProperties((CamelContext)this.camelContext, (Object)config, properties);
        return config;
    }

    private void loadProperties(CamelContext camelContext, Map<String, Object> properties, Optional<?> optional) {
        BeanIntrospection beanIntrospection = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanIntrospection();
        optional.ifPresent(bean -> beanIntrospection.getProperties(bean, properties, null, false));
    }
}

