/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hystrix.metrics;

import com.netflix.hystrix.contrib.metrics.eventstream.HystrixMetricsPoller;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Stream;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed Hystrix EventStreamService")
public class HystrixEventStreamService
extends ServiceSupport
implements StaticService,
HystrixMetricsPoller.MetricsAsJsonPollerListener {
    public static final int METRICS_QUEUE_SIZE = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(HystrixEventStreamService.class);
    private int delay = 500;
    private int queueSize = 1000;
    private HystrixMetricsPoller poller;
    private Queue<String> queue;

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public Stream<String> streamMetrics() {
        if (this.queue != null) {
            return this.queue.stream();
        }
        return null;
    }

    @ManagedOperation(description="Returns the oldest metrics as JSon format")
    public String oldestMetricsAsJSon() {
        if (this.queue != null) {
            return this.queue.peek();
        }
        return null;
    }

    @ManagedOperation(description="Starts the metrics poller")
    public void startPoller() {
        this.poller.start();
    }

    @ManagedOperation(description="Pauses the metrics poller")
    public void pausePoller() {
        this.poller.pause();
    }

    @ManagedAttribute(description="Is the metrics poller running")
    public boolean isPollerRunning() {
        return this.poller.isRunning();
    }

    @ManagedAttribute(description="The delay in millis the poller is running")
    public int getPollerDelay() {
        return this.delay;
    }

    protected void doStart() throws Exception {
        LOG.info("Starting HystrixMetricsPoller with delay: {} and queue size: {}", (Object)this.delay, (Object)this.queueSize);
        this.queue = new LinkedBlockingQueue<String>(this.queueSize);
        this.poller = new HystrixMetricsPoller((HystrixMetricsPoller.MetricsAsJsonPollerListener)this, this.delay);
        this.poller.start();
    }

    protected void doStop() throws Exception {
        if (this.poller != null) {
            LOG.info("Shutting down HystrixMetricsPoller");
            this.poller.shutdown();
        }
    }

    public void handleJsonMetric(String json) {
        LOG.debug("handleJsonMetric: {}", (Object)json);
        int drain = this.queue.size() - this.queueSize + 1;
        if (drain > 0) {
            LOG.debug("Draining queue to make room: {}", (Object)drain);
            for (int i = 0; i < drain; ++i) {
                this.queue.poll();
            }
        }
        this.queue.add(json);
    }
}

