/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.LineNumberAware;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.http.HttpConstants;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpEntityConverter;
import org.apache.camel.component.http.HttpMethods;
import org.apache.camel.component.http.helper.HttpMethodHelper;
import org.apache.camel.http.base.HttpOperationFailedException;
import org.apache.camel.http.base.cookie.CookieHandler;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.http.common.HttpProtocolHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.GZIPHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.support.builder.OutputStreamBuilder;
import org.apache.camel.support.http.HttpUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.MimeTypeHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.FileEntity;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.io.entity.NullEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProducer
extends DefaultProducer
implements LineNumberAware {
    private static final Logger LOG = LoggerFactory.getLogger(HttpProducer.class);
    private static final Integer OK_RESPONSE_CODE = 200;
    private HttpClient httpClient;
    private final HttpContext httpContext;
    private final boolean throwException;
    private final boolean transferException;
    private final HeaderFilterStrategy httpProtocolHeaderFilterStrategy = new HttpProtocolHeaderFilterStrategy();
    private int minOkRange;
    private int maxOkRange;
    private String defaultUrl;
    private URI defaultUri;
    private HttpHost defaultHttpHost;

    public HttpProducer(HttpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.httpContext = endpoint.getHttpContext();
        this.throwException = endpoint.isThrowExceptionOnFailure();
        this.transferException = endpoint.isTransferException();
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.httpClient = this.getEndpoint().getHttpClient();
        String range = this.getEndpoint().getOkStatusCodeRange();
        this.parseStatusRange(range);
        String url = this.getEndpoint().getHttpUri().toASCIIString();
        url = UnsafeUriCharactersEncoder.encodeHttpURI((String)url);
        URI uri = new URI(url);
        String queryString = this.getEndpoint().getHttpUri().getRawQuery();
        if (queryString == null) {
            queryString = uri.getRawQuery();
        }
        if (queryString != null) {
            queryString = UnsafeUriCharactersEncoder.encodeHttpURI((String)queryString);
            uri = URISupport.createURIWithQuery((URI)uri, (String)queryString);
        }
        this.defaultUri = uri;
        this.defaultUrl = uri.toASCIIString();
        this.defaultHttpHost = URIUtils.extractHost((URI)uri);
    }

    private void parseStatusRange(String range) {
        if (!range.contains(",") && !HttpUtil.parseStatusRange((String)range, this::setRanges)) {
            this.maxOkRange = this.minOkRange = Integer.parseInt(range);
        }
    }

    private void setRanges(int minOkRange, int maxOkRange) {
        this.minOkRange = minOkRange;
        this.maxOkRange = maxOkRange;
    }

    public void process(Exchange exchange) throws Exception {
        String hostHeader;
        String key;
        boolean cookies;
        boolean bl = cookies = !this.getEndpoint().getComponent().isCookieManagementDisabled();
        if (cookies && this.getEndpoint().isClearExpiredCookies() && !this.getEndpoint().isBridgeEndpoint()) {
            this.getEndpoint().getCookieStore().clearExpired(Instant.now());
        }
        Map skipRequestHeaders = null;
        if (this.getEndpoint().isBridgeEndpoint()) {
            exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
            String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
            if (queryString != null) {
                skipRequestHeaders = URISupport.parseQuery((String)queryString, (boolean)false, (boolean)true);
            }
        }
        HttpUriRequest httpRequest = this.createMethod(exchange);
        HttpHost httpHost = this.createHost(httpRequest);
        Message in = exchange.getIn();
        String httpProtocolVersion = null;
        if (!this.getEndpoint().isSkipControlHeaders()) {
            httpProtocolVersion = (String)in.getHeader("CamelHttpProtocolVersion", String.class);
        }
        if (httpProtocolVersion != null) {
            int[] version = HttpHelper.parserHttpVersion(httpProtocolVersion);
            httpRequest.setVersion((ProtocolVersion)new HttpVersion(version[0], version[1]));
        }
        HeaderFilterStrategy strategy = this.getEndpoint().getHeaderFilterStrategy();
        if (!this.getEndpoint().isSkipRequestHeaders() && strategy != null) {
            TypeConverter tc = exchange.getContext().getTypeConverter();
            for (Map.Entry entry : in.getHeaders().entrySet()) {
                Object headerValue;
                key = (String)entry.getKey();
                if (skipRequestHeaders != null && skipRequestHeaders.containsKey(key) || (headerValue = entry.getValue()) == null) continue;
                if (headerValue instanceof String || headerValue instanceof Integer || headerValue instanceof Long || headerValue instanceof Boolean || headerValue instanceof Date) {
                    String value = headerValue.toString();
                    if (strategy.applyFilterToCamelHeaders(key, (Object)value, exchange)) continue;
                    httpRequest.addHeader(key, (Object)value);
                    continue;
                }
                Iterator it = ObjectHelper.createIterator(headerValue, null, (boolean)true);
                HttpUtil.applyHeader((HeaderFilterStrategy)strategy, (Exchange)exchange, (Iterator)it, (TypeConverter)tc, (String)key, (multiValues, prev) -> HttpProducer.applyHeader(httpRequest, key, multiValues, prev));
            }
        }
        if (this.getEndpoint().getCookieHandler() != null) {
            Map cookieHeaders = this.getEndpoint().getCookieHandler().loadCookies(exchange, httpRequest.getUri());
            for (Map.Entry entry : cookieHeaders.entrySet()) {
                key = (String)entry.getKey();
                if (((List)entry.getValue()).isEmpty()) continue;
                httpRequest.addHeader(key, (Object)String.join((CharSequence)";", (Iterable)entry.getValue()));
            }
        }
        if (this.getEndpoint().getCustomHostHeader() != null) {
            httpRequest.setHeader("Host", (Object)this.getEndpoint().getCustomHostHeader());
        }
        if (this.getEndpoint().isPreserveHostHeader() && (hostHeader = (String)exchange.getIn().getHeader("Host", String.class)) != null) {
            httpRequest.setHeader("Host", (Object)hostHeader);
        }
        if (this.getEndpoint().isConnectionClose()) {
            httpRequest.addHeader("Connection", (Object)"close");
        }
        try {
            this.executeMethod(exchange, httpHost, httpRequest, httpResponse -> {
                block34: {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Executing http {} method: {}", (Object)httpRequest.getMethod(), (Object)httpRequest.getUri());
                        }
                        int responseCode = httpResponse.getCode();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Http responseCode: {}", (Object)responseCode);
                        }
                        if (!this.throwException) {
                            this.populateResponse(exchange, httpRequest, httpResponse, strategy, responseCode);
                        } else {
                            boolean ok = this.minOkRange > 0 ? responseCode >= this.minOkRange && responseCode <= this.maxOkRange : HttpHelper.isStatusCodeOk((int)responseCode, (String)this.getEndpoint().getOkStatusCodeRange());
                            if (!ok) {
                                HttpProducer.populateResponseCode(exchange.getMessage(), httpResponse, responseCode);
                                throw this.populateHttpOperationFailedException(exchange, httpRequest, httpResponse, responseCode);
                            }
                            this.populateResponse(exchange, httpRequest, httpResponse, strategy, responseCode);
                        }
                        if (httpResponse == null) break block34;
                    }
                    catch (IOException | RuntimeCamelException | HttpException e) {
                        try {
                            throw e;
                            catch (Exception e2) {
                                throw new RuntimeCamelException((Throwable)e2);
                            }
                        }
                        catch (Throwable throwable) {
                            if (httpResponse != null && this.getEndpoint().isDisableStreamCache()) {
                                exchange.getExchangeExtension().addOnCompletion((Synchronization)new SynchronizationAdapter(httpResponse, httpRequest){
                                    final /* synthetic */ ClassicHttpResponse val$httpResponse;
                                    final /* synthetic */ HttpUriRequest val$httpRequest;
                                    {
                                        this.val$httpResponse = classicHttpResponse;
                                        this.val$httpRequest = httpUriRequest;
                                    }

                                    public void onDone(Exchange exchange1) {
                                        try {
                                            EntityUtils.consume((HttpEntity)this.val$httpResponse.getEntity());
                                        }
                                        catch (Exception exception) {
                                        }
                                        finally {
                                            try {
                                                EntityUtils.consume((HttpEntity)this.val$httpRequest.getEntity());
                                            }
                                            catch (Exception exception) {}
                                        }
                                    }
                                });
                                throw throwable;
                            }
                            if (httpResponse == null) throw throwable;
                            try {
                                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                                throw throwable;
                            }
                            catch (Exception exception) {
                                throw throwable;
                            }
                            finally {
                                try {
                                    EntityUtils.consume((HttpEntity)httpRequest.getEntity());
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    if (this.getEndpoint().isDisableStreamCache()) {
                        exchange.getExchangeExtension().addOnCompletion((Synchronization)new /* invalid duplicate definition of identical inner class */);
                        return null;
                    }
                }
                if (httpResponse == null) return null;
                try {
                    EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                    return null;
                }
                catch (Exception responseCode) {
                    return null;
                }
                finally {
                    try {
                        EntityUtils.consume((HttpEntity)httpRequest.getEntity());
                    }
                    catch (Exception responseCode) {}
                }
            });
        }
        catch (RuntimeCamelException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof Exception) {
                Exception ex = (Exception)throwable;
                throw ex;
            }
            throw e;
        }
    }

    private static void applyHeader(HttpUriRequest httpRequest, String key, List<String> multiValues, String prev) {
        if (multiValues != null) {
            String s = multiValues.size() > 1 ? multiValues.toString() : multiValues.get(0);
            httpRequest.addHeader(key, (Object)s);
        } else if (prev != null) {
            httpRequest.addHeader(key, (Object)prev);
        }
    }

    public HttpEndpoint getEndpoint() {
        return (HttpEndpoint)super.getEndpoint();
    }

    protected void populateResponse(Exchange exchange, HttpUriRequest httpRequest, ClassicHttpResponse httpResponse, HeaderFilterStrategy strategy, int responseCode) throws IOException, ClassNotFoundException {
        Message answer = exchange.getOut();
        HttpProducer.populateResponseCode(answer, httpResponse, responseCode);
        Object response = this.extractResponseBody(httpResponse, exchange, this.getEndpoint().isIgnoreResponseBody());
        answer.setBody(response);
        if (!this.getEndpoint().isSkipResponseHeaders()) {
            HashMap<String, List> cookieHeaders = null;
            CookieHandler cookieHandler = this.getEndpoint().getCookieHandler();
            if (cookieHandler != null) {
                cookieHeaders = new HashMap<String, List>();
            }
            boolean found = false;
            Iterator it = httpResponse.headerIterator();
            while (it.hasNext()) {
                Header header = (Header)it.next();
                String name = header.getName();
                String value = header.getValue();
                if (cookieHeaders != null) {
                    cookieHeaders.computeIfAbsent(name, k -> new ArrayList()).add(value);
                }
                if (!found && name.equalsIgnoreCase("content-type")) {
                    name = "Content-Type";
                    exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)IOHelper.getCharsetNameFromContentType((String)value));
                    found = true;
                }
                Object extracted = HttpHelper.extractHttpParameterValue((String)value);
                if (strategy == null || strategy.applyFilterToExternalHeaders(name, extracted, exchange)) continue;
                HttpHelper.appendHeader((Map)answer.getHeaders(), (String)name, (Object)extracted);
            }
            if (cookieHandler != null) {
                try {
                    cookieHandler.storeCookies(exchange, httpRequest.getUri(), cookieHeaders);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeCamelException((Throwable)e);
                }
            }
        }
        if (this.getEndpoint().isCopyHeaders()) {
            MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)answer, (HeaderFilterStrategy)this.httpProtocolHeaderFilterStrategy, (boolean)false);
        }
    }

    private static void populateResponseCode(Message message, ClassicHttpResponse httpResponse, int responseCode) {
        if (responseCode == 200) {
            message.setHeader("CamelHttpResponseCode", (Object)OK_RESPONSE_CODE);
        } else {
            message.setHeader("CamelHttpResponseCode", (Object)responseCode);
        }
        if (httpResponse.getReasonPhrase() != null) {
            message.setHeader("CamelHttpResponseText", (Object)httpResponse.getReasonPhrase());
        }
    }

    protected Exception populateHttpOperationFailedException(Exchange exchange, HttpUriRequest httpRequest, ClassicHttpResponse httpResponse, int responseCode) throws IOException, ClassNotFoundException {
        HttpOperationFailedException answer;
        String statusText = httpResponse.getReasonPhrase() != null ? httpResponse.getReasonPhrase() : null;
        Map<String, String> headers = HttpProducer.extractResponseHeaders(httpResponse.getHeaders());
        CookieHandler cookieHandler = this.getEndpoint().getCookieHandler();
        if (cookieHandler != null) {
            HashMap<String, List<String>> m = new HashMap<String, List<String>>();
            for (Map.Entry<String, String> e : headers.entrySet()) {
                m.put(e.getKey(), Collections.singletonList(e.getValue()));
            }
            try {
                cookieHandler.storeCookies(exchange, httpRequest.getUri(), m);
            }
            catch (URISyntaxException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }
        Object responseBody = this.extractResponseBody(httpResponse, exchange, this.getEndpoint().isIgnoreResponseBody());
        if (this.transferException && responseBody instanceof Exception) {
            Exception ex = (Exception)responseBody;
            return ex;
        }
        String copy = null;
        if (responseBody != null) {
            copy = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, responseBody);
        }
        Header locationHeader = httpResponse.getFirstHeader("location");
        try {
            String uri = httpRequest.getUri().toString();
            answer = locationHeader != null && responseCode >= 300 && responseCode < 400 ? new HttpOperationFailedException(uri, responseCode, statusText, locationHeader.getValue(), headers, copy) : new HttpOperationFailedException(uri, responseCode, statusText, null, headers, copy);
        }
        catch (URISyntaxException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    protected <T> T executeMethod(Exchange exchange, HttpHost httpHost, HttpUriRequest httpRequest, HttpClientResponseHandler<T> handler) throws IOException, HttpException {
        Object localContext = this.httpContext != null ? new BasicHttpContext(this.httpContext) : HttpClientContext.create();
        if (this.getEndpoint().getHttpActivityListener() != null) {
            localContext.setAttribute("org.apache.camel.Exchange", (Object)exchange);
            localContext.setAttribute("org.apache.hc.core5.http.HttpHost", (Object)httpHost);
        }
        ClassicHttpResponse res = this.httpClient.executeOpen(httpHost, (ClassicHttpRequest)httpRequest, (HttpContext)localContext);
        return (T)handler.handleResponse(res);
    }

    protected static Map<String, String> extractResponseHeaders(Header[] responseHeaders) {
        if (responseHeaders == null || responseHeaders.length == 0) {
            return Map.of();
        }
        HashMap<String, String> answer = new HashMap<String, String>();
        for (Header header : responseHeaders) {
            answer.put(header.getName(), header.getValue());
        }
        return answer;
    }

    protected Object extractResponseBody(ClassicHttpResponse httpResponse, Exchange exchange, boolean ignoreResponseBody) throws IOException, ClassNotFoundException {
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            return null;
        }
        InputStream is = entity.getContent();
        if (is == null) {
            return null;
        }
        Header header = httpResponse.getFirstHeader("Content-Encoding");
        String contentEncoding = header != null ? header.getValue() : null;
        boolean gzipEncoding = (Boolean)exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class);
        if (!gzipEncoding) {
            is = GZIPHelper.uncompressGzip((String)contentEncoding, (InputStream)is);
        }
        String contentType = null;
        header = httpResponse.getFirstHeader("content-type");
        if (header != null) {
            contentType = header.getValue();
            HttpHelper.setCharsetFromContentType((String)contentType, (Exchange)exchange);
        }
        if (ignoreResponseBody) {
            return null;
        }
        if (contentType != null && contentType.equals("application/x-java-serialized-object")) {
            if (this.getEndpoint().getComponent().isAllowJavaSerializedObject() || this.getEndpoint().isTransferException()) {
                return HttpHelper.deserializeJavaObjectFromStream((InputStream)is, (CamelContext)exchange.getContext());
            }
            return null;
        }
        if (entity.isStreaming()) {
            long len;
            if (this.getEndpoint().isDisableStreamCache()) {
                return is;
            }
            int max = this.getEndpoint().getComponent().getResponsePayloadStreamingThreshold();
            if (max > 0 && (len = entity.getContentLength()) > 0L && len <= (long)max) {
                int read;
                int i = (int)len;
                byte[] arr = new byte[i];
                int offset = 0;
                for (int remain = i; (read = is.read(arr, offset, remain)) > 0 && remain > 0; remain -= read) {
                    offset += read;
                }
                IOHelper.close((Closeable)is);
                return arr;
            }
            return this.doExtractResponseBodyAsStream(is, exchange);
        }
        return is;
    }

    private Object doExtractResponseBodyAsStream(InputStream is, Exchange exchange) throws IOException {
        OutputStreamBuilder osb = OutputStreamBuilder.withExchange((Exchange)exchange);
        IOHelper.copy((InputStream)is, (OutputStream)osb);
        return osb.build();
    }

    protected HttpHost createHost(HttpUriRequest httpRequest) {
        try {
            URI uri = httpRequest.getUri();
            if (uri.equals(this.defaultUri)) {
                return this.defaultHttpHost;
            }
            return HttpHost.create((URI)uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    protected HttpUriRequest createMethod(Exchange exchange) throws Exception {
        boolean create;
        if (this.defaultUri == null || this.defaultUrl == null) {
            throw new IllegalArgumentException("Producer must be started");
        }
        String url = this.defaultUrl;
        URI uri = this.defaultUri;
        boolean bl = create = !this.getEndpoint().isSkipControlHeaders() && this.isCreateNewURL(exchange);
        if (create) {
            url = HttpHelper.createURL((Exchange)exchange, (HttpCommonEndpoint)this.getEndpoint());
            uri = HttpHelper.createURI((Exchange)exchange, (String)url, (HttpCommonEndpoint)this.getEndpoint());
            url = uri.toASCIIString();
        }
        HttpMethods methodToUse = HttpMethodHelper.createMethod(exchange, this.getEndpoint());
        HttpUriRequest method = methodToUse.createMethod(url);
        if (this.getEndpoint().isDeleteWithBody() && "DELETE".equals(method.getMethod()) || this.getEndpoint().isGetWithBody() && "GET".equals(method.getMethod())) {
            method.setEntity(this.createRequestEntity(exchange));
        }
        LOG.trace("Using URL: {} with method: {}", (Object)url, (Object)method);
        if (methodToUse.isEntityEnclosing()) {
            HttpEntity requestEntity = this.createRequestEntity(exchange);
            method.setEntity(requestEntity);
            if (requestEntity != null && requestEntity.getContentType() == null) {
                LOG.debug("No Content-Type provided for URL: {} with exchange: {}", (Object)url, (Object)exchange);
            }
        }
        if (uri.getScheme() == null || uri.getHost() == null) {
            throw new IllegalArgumentException("Invalid url: " + url + ". If you are forwarding/bridging http endpoints, then enable the bridgeEndpoint option on the endpoint: " + String.valueOf((Object)this.getEndpoint()));
        }
        return method;
    }

    private boolean isCreateNewURL(Exchange exchange) {
        boolean create = false;
        Message in = exchange.getIn();
        if (in.getHeader("CamelRestHttpUri") != null) {
            create = true;
        } else if (in.getHeader("CamelHttpUri") != null && !this.getEndpoint().isBridgeEndpoint()) {
            create = true;
        } else if (in.getHeader("CamelHttpPath") != null) {
            create = true;
        } else if (in.getHeader("CamelRestHttpQuery") != null) {
            create = true;
        } else if (in.getHeader("CamelHttpRawQuery") != null) {
            create = true;
        } else if (in.getHeader("CamelHttpQuery") != null) {
            create = true;
        }
        return create;
    }

    protected HttpEntity createRequestEntity(Exchange exchange) throws CamelExchangeException {
        String content;
        Object answer = null;
        Message in = exchange.getIn();
        Object body = in.getBody();
        boolean multipart = this.getEndpoint().isMultipartUpload();
        String multipartName = this.getEndpoint().getMultipartUploadName();
        try {
            if (body == null) {
                return NullEntity.INSTANCE;
            }
            if (body instanceof HttpEntity) {
                HttpEntity entity;
                answer = entity = (HttpEntity)body;
            } else if (!multipart && body instanceof byte[]) {
                byte[] bytes = (byte[])body;
                answer = HttpEntityConverter.toHttpEntity(bytes, exchange);
            } else if (!multipart && body instanceof InputStream) {
                InputStream is = (InputStream)body;
                answer = HttpEntityConverter.toHttpEntity(is, exchange);
            } else if (!multipart && body instanceof String) {
                content = (String)body;
                answer = HttpEntityConverter.toHttpEntity(content, exchange);
            }
        }
        catch (Exception e) {
            throw new CamelExchangeException("Error creating RequestEntity from message body", exchange, (Throwable)e);
        }
        if (answer == null) {
            try {
                Object data = in.getBody();
                if (data != null) {
                    String contentTypeString = ExchangeHelper.getContentType((Exchange)exchange);
                    ContentType contentType = null;
                    if (contentTypeString != null) {
                        contentType = contentTypeString.contains("charset") || contentTypeString.contains(";") ? ContentType.parse((CharSequence)contentTypeString) : ContentType.create((String)contentTypeString);
                    }
                    if (contentTypeString != null && "application/x-java-serialized-object".equals(contentTypeString)) {
                        if (!this.getEndpoint().getComponent().isAllowJavaSerializedObject()) {
                            throw new CamelExchangeException("Content-type application/x-java-serialized-object is not allowed", exchange);
                        }
                        Serializable obj = (Serializable)in.getMandatoryBody(Serializable.class);
                        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                            HttpHelper.writeObjectToStream((OutputStream)bos, (Object)obj);
                            answer = new ByteArrayEntity(bos.toByteArray(), HttpConstants.JAVA_SERIALIZED_OBJECT);
                        }
                    } else if (data instanceof File || data instanceof WrappedFile) {
                        File file = (File)in.getBody(File.class);
                        if (file != null) {
                            if (contentType == null) {
                                String type = MimeTypeHelper.probeMimeType((String)file.getName());
                                if (type != null) {
                                    contentType = ContentType.parseLenient((CharSequence)type);
                                }
                                if (contentType == null) {
                                    contentType = ContentType.DEFAULT_BINARY;
                                }
                            }
                            answer = multipart ? MultipartEntityBuilder.create().addBinaryBody(multipartName, file, contentType, file.getName()).build() : new FileEntity(file, contentType);
                        }
                    } else if (data instanceof String) {
                        Charset cs;
                        content = (String)data;
                        String charset = ExchangeHelper.getCharsetName((Exchange)exchange, (boolean)false);
                        if (charset == null && contentType != null && (cs = contentType.getCharset()) != null) {
                            charset = cs.name();
                        }
                        if (contentType != null && contentType.getCharset() == null && charset != null) {
                            contentType = ContentType.parse((CharSequence)(String.valueOf(contentType) + ";charset=" + charset));
                        }
                        answer = multipart ? (contentType != null ? MultipartEntityBuilder.create().addTextBody(multipartName, content, contentType).build() : MultipartEntityBuilder.create().addTextBody(multipartName, content).build()) : new StringEntity(content, contentType, false);
                    }
                    if (answer == null) {
                        InputStream is = (InputStream)in.getMandatoryBody(InputStream.class);
                        answer = multipart ? MultipartEntityBuilder.create().addBinaryBody(multipartName, is).build() : new InputStreamEntity(is, -1L, contentType);
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new CamelExchangeException("Error creating RequestEntity from message body", exchange, (Throwable)e);
            }
            catch (IOException e) {
                throw new CamelExchangeException("Error serializing message body", exchange, (Throwable)e);
            }
        }
        return answer;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public int getLineNumber() {
        return this.getEndpoint().getLineNumber();
    }

    public void setLineNumber(int lineNumber) {
    }

    public String getLocation() {
        return this.getEndpoint().getLocation();
    }

    public void setLocation(String location) {
    }
}

