/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpMethods;
import org.apache.camel.component.http.HttpOperationFailedException;
import org.apache.camel.component.http.helper.GZIPHelper;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(HttpProducer.class);
    private HttpClient httpClient;

    public HttpProducer(HttpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.httpClient = endpoint.createHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        HttpMethod method = this.createMethod(exchange);
        Message in = exchange.getIn();
        HeaderFilterStrategy strategy = ((HttpEndpoint)this.getEndpoint()).getHeaderFilterStrategy();
        for (String headerName : in.getHeaders().keySet()) {
            String headerValue = (String)in.getHeader(headerName, String.class);
            if (strategy == null || strategy.applyFilterToCamelHeaders(headerName, (Object)headerValue)) continue;
            method.addRequestHeader(headerName, headerValue);
        }
        try {
            Header[] headers;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Executing http " + method.getName() + " method: " + method.getURI().toString()));
            }
            int responseCode = this.executeMethod(method);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Http responseCode: " + responseCode));
            }
            if (responseCode >= 100 && responseCode < 300) {
                Message answer = exchange.getOut(true);
                answer.setHeaders(in.getHeaders());
                answer.setHeader("CamelHttpResponseCode", (Object)responseCode);
                answer.setBody((Object)HttpProducer.extractResponseBody(method, exchange));
                for (Header header : headers = method.getResponseHeaders()) {
                    String name = header.getName();
                    String value = header.getValue();
                    if (strategy == null || strategy.applyFilterToExternalHeaders(name, (Object)value)) continue;
                    answer.setHeader(name, (Object)value);
                }
            } else {
                HttpOperationFailedException exception = null;
                headers = method.getResponseHeaders();
                InputStream is = HttpProducer.extractResponseBody(method, exchange);
                if (responseCode >= 300 && responseCode < 400) {
                    Header locationHeader = method.getResponseHeader("location");
                    if (locationHeader != null) {
                        String redirectLocation = locationHeader.getValue();
                        exception = new HttpOperationFailedException(responseCode, method.getStatusLine(), redirectLocation, headers, is);
                    } else {
                        exception = new HttpOperationFailedException(responseCode, method.getStatusLine(), headers, is);
                    }
                } else {
                    exception = new HttpOperationFailedException(responseCode, method.getStatusLine(), headers, is);
                }
                if (exception != null) {
                    throw exception;
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    protected int executeMethod(HttpMethod method) throws IOException {
        return this.httpClient.executeMethod(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static InputStream extractResponseBody(HttpMethod method, Exchange exchange) throws IOException {
        InputStream is;
        CachedOutputStream cos;
        block3: {
            InputStream inputStream;
            cos = null;
            is = null;
            try {
                cos = new CachedOutputStream(exchange.getContext().getProperties());
                is = GZIPHelper.getInputStream(method);
                if (is != null) break block3;
                inputStream = null;
            }
            catch (Throwable throwable) {
                ObjectHelper.close(is, (String)"Extracting response body", (Log)LOG);
                throw throwable;
            }
            ObjectHelper.close((Closeable)is, (String)"Extracting response body", (Log)LOG);
            return inputStream;
        }
        IOUtils.copy((InputStream)is, (OutputStream)cos);
        cos.flush();
        InputStream inputStream = cos.getInputStream();
        ObjectHelper.close((Closeable)is, (String)"Extracting response body", (Log)LOG);
        return inputStream;
    }

    protected HttpMethod createMethod(Exchange exchange) {
        String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        if (queryString == null) {
            queryString = ((HttpEndpoint)this.getEndpoint()).getHttpUri().getQuery();
        }
        RequestEntity requestEntity = this.createRequestEntity(exchange);
        HttpMethods m = (HttpMethods)((Object)exchange.getIn().getHeader("CamelHttpMethod", HttpMethods.class));
        HttpMethods methodToUse = m != null ? m : (queryString != null ? HttpMethods.GET : (requestEntity != null ? HttpMethods.POST : HttpMethods.GET));
        String uri = (String)exchange.getIn().getHeader("CamelHttpUri", String.class);
        if (uri == null) {
            uri = ((HttpEndpoint)this.getEndpoint()).getHttpUri().toString();
        }
        HttpMethod method = methodToUse.createMethod(uri);
        if (queryString != null) {
            method.setQueryString(queryString);
        }
        if (methodToUse.isEntityEnclosing()) {
            ((EntityEnclosingMethod)method).setRequestEntity(requestEntity);
        }
        return method;
    }

    protected RequestEntity createRequestEntity(Exchange exchange) {
        Message in = exchange.getIn();
        if (in.getBody() == null) {
            return null;
        }
        try {
            return (RequestEntity)in.getBody(RequestEntity.class);
        }
        catch (NoTypeConversionAvailableException ex) {
            try {
                String data = (String)in.getBody(String.class);
                if (data != null) {
                    String contentType = (String)in.getHeader("Content-Type", String.class);
                    String charset = (String)exchange.getProperty("CamelCharsetName", String.class);
                    return new StringRequestEntity(data, contentType, charset);
                }
                return null;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

