/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Message;
import org.apache.camel.component.http.HttpBinding;
import org.apache.camel.component.http.HttpExchange;
import org.apache.camel.component.http.HttpHeaderFilterStrategy;
import org.apache.camel.component.http.HttpMessage;
import org.apache.camel.spi.HeaderFilterStrategy;

public class DefaultHttpBinding
implements HttpBinding {
    private boolean useReaderForPayload;
    private HeaderFilterStrategy headerFilterStrategy = new HttpHeaderFilterStrategy();

    public DefaultHttpBinding() {
    }

    public DefaultHttpBinding(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public void readRequest(HttpServletRequest request, HttpMessage message) {
        message.getBody();
        message.getHeaders();
    }

    public void writeResponse(HttpExchange exchange, HttpServletResponse response) throws IOException {
        if (exchange.isFailed()) {
            Message fault = exchange.getFault(false);
            if (fault != null) {
                this.doWriteFaultResponse(fault, response);
            } else {
                this.doWriteExceptionResponse(exchange.getException(), response);
            }
        } else {
            Message out = exchange.getOut();
            if (out != null) {
                this.doWriteResponse(out, response);
            }
        }
    }

    public void doWriteExceptionResponse(Throwable exception, HttpServletResponse response) throws IOException {
        response.setStatus(500);
        response.setContentType("text/plain");
        PrintWriter pw = response.getWriter();
        exception.printStackTrace(pw);
        pw.flush();
    }

    public void doWriteFaultResponse(Message message, HttpServletResponse response) throws IOException {
        this.doWriteResponse(message, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWriteResponse(Message message, HttpServletResponse response) throws IOException {
        if (message.getHeader("http.responseCode") != null) {
            int code = (Integer)message.getHeader("http.responseCode", Integer.class);
            response.setStatus(code);
        }
        if (message.getHeader("Content-Type") != null) {
            String contentType = (String)message.getHeader("Content-Type", String.class);
            response.setContentType(contentType);
        }
        for (String key : message.getHeaders().keySet()) {
            String value = (String)message.getHeader(key, String.class);
            if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)value)) continue;
            response.setHeader(key, value);
        }
        if (message.getBody() != null) {
            InputStream is = (InputStream)message.getBody(InputStream.class);
            int length = 0;
            if (is != null) {
                ServletOutputStream os = null;
                try {
                    int c;
                    os = response.getOutputStream();
                    while ((c = is.read()) >= 0) {
                        os.write(c);
                        ++length;
                    }
                    response.setContentLength(length);
                    os.flush();
                }
                finally {
                    os.close();
                    is.close();
                }
            } else {
                String data = (String)message.getBody(String.class);
                if (data != null) {
                    response.setContentLength(data.length());
                    response.getWriter().print(data);
                    response.getWriter().flush();
                }
            }
        }
    }

    public Object parseBody(HttpMessage httpMessage) throws IOException {
        HttpServletRequest request = httpMessage.getRequest();
        if (this.isUseReaderForPayload()) {
            return request.getReader();
        }
        return request.getInputStream();
    }

    public boolean isUseReaderForPayload() {
        return this.useReaderForPayload;
    }

    public void setUseReaderForPayload(boolean useReaderForPayload) {
        this.useReaderForPayload = useReaderForPayload;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }
}

