/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpExchange;
import org.apache.camel.component.http.HttpMethods;
import org.apache.camel.component.http.HttpOperationFailedException;
import org.apache.camel.component.http.helper.LoadingByteArrayOutputStream;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpProducer
extends DefaultProducer<HttpExchange>
implements Producer<HttpExchange> {
    public static final String HTTP_RESPONSE_CODE = "http.responseCode";
    public static final String QUERY = "org.apache.camel.component.http.query";
    @Deprecated
    public static final Set<String> HEADERS_TO_SKIP = new HashSet<String>(Arrays.asList("content-length", "content-type", "http.responseCode".toLowerCase()));
    private static final transient Log LOG = LogFactory.getLog(HttpProducer.class);
    private HttpClient httpClient;

    public HttpProducer(HttpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.httpClient = endpoint.createHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        block11: {
            HttpMethod method = this.createMethod(exchange);
            Message in = exchange.getIn();
            HeaderFilterStrategy strategy = ((HttpEndpoint)this.getEndpoint()).getHeaderFilterStrategy();
            for (String headerName : in.getHeaders().keySet()) {
                String headerValue = (String)in.getHeader(headerName, String.class);
                if (strategy == null || strategy.applyFilterToCamelHeaders(headerName, (Object)headerValue)) continue;
                method.addRequestHeader(headerName, headerValue);
            }
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Executing http " + method.getName() + " method: " + method.getURI().toString()));
                }
                int responseCode = this.executeMethod(method);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Http responseCode: " + responseCode));
                }
                if (responseCode >= 100 && responseCode < 300) {
                    Header[] headers;
                    Message answer = exchange.getOut(true);
                    answer.setHeaders(in.getHeaders());
                    answer.setHeader(HTTP_RESPONSE_CODE, (Object)responseCode);
                    answer.setBody((Object)HttpProducer.extractResponseBody(method));
                    for (Header header : headers = method.getResponseHeaders()) {
                        String name = header.getName();
                        String value = header.getValue();
                        if (strategy == null || strategy.applyFilterToExternalHeaders(name, (Object)value)) continue;
                        answer.setHeader(name, (Object)value);
                    }
                    break block11;
                }
                HttpOperationFailedException exception = null;
                if (responseCode < 400 && responseCode >= 300) {
                    Header locationHeader = method.getResponseHeader("location");
                    if (locationHeader != null) {
                        String redirectLocation = locationHeader.getValue();
                        exception = new HttpOperationFailedException(responseCode, method.getStatusLine(), redirectLocation);
                    }
                } else {
                    exception = new HttpOperationFailedException(responseCode, method.getStatusLine());
                }
                throw exception;
            }
            finally {
                method.releaseConnection();
            }
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected int executeMethod(HttpMethod method) throws IOException {
        return this.httpClient.executeMethod(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static InputStream extractResponseBody(HttpMethod method) throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        LoadingByteArrayOutputStream bos = null;
        InputStream is = null;
        try {
            bos = new LoadingByteArrayOutputStream();
            is = method.getResponseBodyAsStream();
            IOUtils.copy((InputStream)is, (OutputStream)bos);
            bos.flush();
            byteArrayInputStream = bos.createInputStream();
        }
        catch (Throwable throwable) {
            ObjectHelper.close(is, (String)"Extracting response body", (Log)LOG);
            ObjectHelper.close((Closeable)bos, (String)"Extracting response body", (Log)LOG);
            throw throwable;
        }
        ObjectHelper.close((Closeable)is, (String)"Extracting response body", (Log)LOG);
        ObjectHelper.close((Closeable)bos, (String)"Extracting response body", (Log)LOG);
        return byteArrayInputStream;
    }

    protected HttpMethod createMethod(Exchange exchange) {
        String queryString = (String)exchange.getIn().getHeader(QUERY, String.class);
        if (queryString == null) {
            queryString = ((HttpEndpoint)this.getEndpoint()).getHttpUri().getQuery();
        }
        RequestEntity requestEntity = this.createRequestEntity(exchange);
        HttpMethods m = (HttpMethods)((Object)exchange.getIn().getHeader("http.requestMethod", HttpMethods.class));
        HttpMethods methodToUse = m != null ? m : (queryString != null ? HttpMethods.GET : (requestEntity != null ? HttpMethods.POST : HttpMethods.GET));
        String uri = ((HttpEndpoint)this.getEndpoint()).getHttpUri().toString();
        HttpMethod method = methodToUse.createMethod(uri);
        if (queryString != null) {
            method.setQueryString(queryString);
        }
        if (methodToUse.isEntityEnclosing()) {
            ((EntityEnclosingMethod)method).setRequestEntity(requestEntity);
        }
        return method;
    }

    protected RequestEntity createRequestEntity(Exchange exchange) {
        Message in = exchange.getIn();
        if (in.getBody() == null) {
            return null;
        }
        try {
            return (RequestEntity)in.getBody(RequestEntity.class);
        }
        catch (NoTypeConversionAvailableException ex) {
            try {
                String data = (String)in.getBody(String.class);
                if (data != null) {
                    String contentType = (String)in.getHeader("Content-Type", String.class);
                    String charset = (String)exchange.getProperty("org.apache.camel.Exchange.CharsetName", String.class);
                    return new StringRequestEntity(data, contentType, charset);
                }
                return null;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }
    }
}

