/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Producer;
import org.apache.camel.component.http.HttpBinding;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpExchange;
import org.apache.camel.component.http.HttpMethods;
import org.apache.camel.component.http.helper.LoadingByteArrayOutputStream;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpProducer
extends DefaultProducer<HttpExchange>
implements Producer<HttpExchange> {
    public static final String HTTP_RESPONSE_CODE = "http.responseCode";
    public static final String QUERY = "org.apache.camel.component.http.query";
    public static final Set<String> HEADERS_TO_SKIP = new HashSet<String>(Arrays.asList("content-length", "content-type", "http.responseCode".toLowerCase()));
    private HttpClient httpClient;

    public HttpProducer(HttpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.httpClient = endpoint.createHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        Header[] headers;
        HttpMethod method = this.createMethod(exchange);
        Message in = exchange.getIn();
        HttpBinding binding = ((HttpEndpoint)this.getEndpoint()).getBinding();
        for (String headerName : in.getHeaders().keySet()) {
            String headerValue;
            if (!binding.shouldHeaderBePropagated(headerName, headerValue = (String)in.getHeader(headerName, String.class))) continue;
            method.addRequestHeader(headerName, headerValue);
        }
        Message out = exchange.getOut(true);
        try {
            int responseCode = this.httpClient.executeMethod(method);
            out.setHeaders(in.getHeaders());
            out.setHeader(HTTP_RESPONSE_CODE, (Object)responseCode);
            LoadingByteArrayOutputStream bos = new LoadingByteArrayOutputStream();
            InputStream is = method.getResponseBodyAsStream();
            IOUtils.copy((InputStream)is, (OutputStream)bos);
            bos.flush();
            is.close();
            out.setBody((Object)bos.createInputStream());
        }
        finally {
            method.releaseConnection();
        }
        for (Header header : headers = method.getResponseHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            out.setHeader(name, (Object)value);
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected HttpMethod createMethod(Exchange exchange) {
        String uri = ((HttpEndpoint)this.getEndpoint()).getHttpUri().toString();
        RequestEntity requestEntity = this.createRequestEntity(exchange);
        Object m = exchange.getIn().getHeader("http.requestMethod");
        HttpMethods ms = m instanceof HttpMethods ? (HttpMethods)((Object)m) : HttpMethods.valueOf(m == null ? (requestEntity == null ? "GET" : "POST") : m.toString());
        HttpMethod method = ms.createMethod(uri);
        if (exchange.getIn().getHeader(QUERY) != null) {
            method.setQueryString((String)exchange.getIn().getHeader(QUERY, String.class));
        }
        if (ms.isEntityEnclosing()) {
            ((EntityEnclosingMethod)method).setRequestEntity(requestEntity);
        }
        return method;
    }

    protected RequestEntity createRequestEntity(Exchange exchange) {
        Message in = exchange.getIn();
        if (in.getBody() == null) {
            return null;
        }
        RequestEntity entity = (RequestEntity)in.getBody(RequestEntity.class);
        if (entity == null) {
            String data = (String)in.getBody(String.class);
            String contentType = (String)in.getHeader("Content-Type", String.class);
            try {
                if (contentType != null) {
                    return new StringRequestEntity(data, contentType, null);
                }
                return new StringRequestEntity(data, null, null);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return entity;
    }

    protected boolean shouldHeaderBePropagated(String headerName, String headerValue) {
        if (headerValue == null) {
            return false;
        }
        if ("http.requestMethod".equals(headerName)) {
            return false;
        }
        if (headerName.startsWith("org.apache.camel")) {
            return false;
        }
        return !HEADERS_TO_SKIP.contains(headerName.toLowerCase());
    }
}

