/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.util.HashMap;
import javax.servlet.Servlet;
import org.apache.camel.component.http.CamelServlet;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpEndpoint;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class JettyHttpComponent
extends HttpComponent {
    Server server;
    final HashMap<String, ConnectorRef> connectors = new HashMap();

    protected void doStart() throws Exception {
        this.server = this.createServer();
        super.doStart();
    }

    private Server createServer() throws Exception {
        this.setCamelServlet(new CamelServlet());
        Server server = new Server();
        Context context = new Context(0);
        context.setContextPath("/");
        ServletHolder holder = new ServletHolder();
        holder.setServlet((Servlet)this.getCamelServlet());
        context.addServlet(holder, "/*");
        server.setHandler((Handler)context);
        server.start();
        return server;
    }

    protected void doStop() throws Exception {
        for (ConnectorRef connectorRef : this.connectors.values()) {
            connectorRef.connector.stop();
        }
        this.connectors.clear();
        this.server.stop();
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(HttpConsumer consumer) throws Exception {
        HttpEndpoint endpoint = consumer.getEndpoint();
        String connectorKey = endpoint.getProtocol() + ":" + endpoint.getPort();
        HashMap<String, ConnectorRef> hashMap = this.connectors;
        synchronized (hashMap) {
            ConnectorRef connectorRef = this.connectors.get(connectorKey);
            if (connectorRef == null) {
                Object connector = "https".equals(endpoint.getProtocol()) ? new SslSocketConnector() : new SelectChannelConnector();
                connector.setPort(endpoint.getPort());
                this.server.addConnector((Connector)connector);
                connector.start();
                connectorRef = new ConnectorRef((Connector)connector);
            } else {
                connectorRef.increment();
            }
        }
        super.connect(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(HttpConsumer consumer) throws Exception {
        super.disconnect(consumer);
        HttpEndpoint endpoint = consumer.getEndpoint();
        String connectorKey = endpoint.getProtocol() + ":" + endpoint.getPort();
        HashMap<String, ConnectorRef> hashMap = this.connectors;
        synchronized (hashMap) {
            ConnectorRef connectorRef = this.connectors.get(connectorKey);
            if (connectorRef != null && connectorRef.decrement() == 0) {
                this.server.removeConnector(connectorRef.connector);
                connectorRef.connector.stop();
                this.connectors.remove(connectorKey);
            }
        }
    }

    class ConnectorRef {
        Connector connector;
        int refCount = 0;

        public ConnectorRef(Connector connector) {
            this.connector = connector;
            this.increment();
        }

        public int increment() {
            return ++this.refCount;
        }

        public int decrement() {
            return --this.refCount;
        }
    }
}

