/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.InputStream;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Producer;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.HttpExchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpProducer
extends DefaultProducer<HttpExchange>
implements Producer<HttpExchange> {
    private HttpClient httpClient = new HttpClient();

    public HttpProducer(HttpEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        Header[] headers;
        HttpMethod method = this.createMethod(exchange);
        int responseCode = this.httpClient.executeMethod(method);
        InputStream in = method.getResponseBodyAsStream();
        Message out = exchange.getOut(true);
        out.setBody((Object)in);
        for (Header header : headers = method.getResponseHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            out.setHeader(name, (Object)value);
        }
        out.setHeader("http.responseCode", (Object)responseCode);
    }

    protected HttpMethod createMethod(Exchange exchange) {
        String uri = this.getEndpoint().getEndpointUri();
        RequestEntity requestEntity = this.createRequestEntity(exchange);
        if (requestEntity == null) {
            return new GetMethod(uri);
        }
        PostMethod method = new PostMethod(uri);
        method.setRequestEntity(requestEntity);
        return method;
    }

    protected RequestEntity createRequestEntity(Exchange exchange) {
        Message in = exchange.getIn();
        RequestEntity entity = (RequestEntity)in.getBody(RequestEntity.class);
        if (entity == null) {
            byte[] data = (byte[])in.getBody(byte[].class);
            String contentType = (String)in.getHeader("Content-Type", String.class);
            if (contentType != null) {
                return new ByteArrayRequestEntity(data, contentType);
            }
            return new ByteArrayRequestEntity(data);
        }
        return entity;
    }
}

