/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.ObjectHelper;

public class HttpMessage
extends DefaultMessage {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final HttpCommonEndpoint endpoint;
    private boolean requestRead;

    public HttpMessage(Exchange exchange, HttpCommonEndpoint endpoint, HttpServletRequest request, HttpServletResponse response) {
        this.setExchange(exchange);
        this.setCamelContext(exchange.getContext());
        this.endpoint = endpoint;
        this.requestRead = false;
        this.request = request;
        this.response = response;
        this.setHeader("CamelHttpServletRequest", request);
        this.setHeader("CamelHttpServletResponse", response);
        Boolean flag = (Boolean)exchange.getProperty("CamelSkipWwwFormUrlEncoding", Boolean.class);
        if (flag != null && flag.booleanValue()) {
            this.setHeader("CamelSkipWwwFormUrlEncoding", Boolean.TRUE);
        }
        endpoint.getHttpBinding().readRequest(request, this);
    }

    private HttpMessage(HttpServletRequest request, HttpServletResponse response, Exchange exchange, HttpCommonEndpoint endpoint, boolean requestRead) {
        this.request = request;
        this.response = response;
        this.setExchange(this.getExchange());
        this.endpoint = endpoint;
        this.setCamelContext(exchange.getContext());
        this.requestRead = requestRead;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    protected Object createBody() {
        if (this.requestRead) {
            return null;
        }
        try {
            Object object = this.endpoint.getHttpBinding().parseBody(this);
            return object;
        }
        catch (IOException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
        finally {
            this.requestRead = true;
        }
    }

    public HttpMessage newInstance() {
        return new HttpMessage(this.request, this.response, this.getExchange(), this.endpoint, this.requestRead);
    }

    public String toString() {
        return "HttpMessage@" + ObjectHelper.getIdentityHashCode((Object)((Object)this));
    }
}

