/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsOsgiHelper {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsOsgiHelper.class);

    public HdfsOsgiHelper(Map<String, String> fileSystems) {
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Configuration conf = new Configuration();
            conf.setClassLoader(cl);
            for (Map.Entry<String, String> fsEntry : fileSystems.entrySet()) {
                URI uri = URI.create(fsEntry.getKey());
                conf.setClass(String.format("fs.%s.impl", uri.getScheme()), cl.loadClass(fsEntry.getValue()), FileSystem.class);
                LOG.debug("Successfully loaded class: {}", (Object)fsEntry.getValue());
                FileSystem.get((URI)uri, (Configuration)conf);
                LOG.debug("Successfully got uri: {} from FileSystem Object", (Object)uri);
            }
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Throwable)e);
        }
    }
}

