/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc.auth.jwt;

import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.concurrent.Executor;
import org.apache.camel.component.grpc.GrpcConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtCallCredentials
extends CallCredentials {
    private static final Logger LOG = LoggerFactory.getLogger(JwtCallCredentials.class);
    private final String jwtToken;

    public JwtCallCredentials(String jwtToken) {
        this.jwtToken = jwtToken;
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor executor, CallCredentials.MetadataApplier metadataApplier) {
        String authority = requestInfo.getAuthority();
        LOG.debug("Using authority {} for credentials", (Object)authority);
        executor.execute(() -> {
            try {
                LOG.debug("Start to apply for the JWT token header");
                Metadata headers = new Metadata();
                Metadata.Key<String> jwtKey = GrpcConstants.GRPC_JWT_METADATA_KEY;
                headers.put(jwtKey, (Object)this.jwtToken);
                metadataApplier.apply(headers);
            }
            catch (Throwable e) {
                LOG.debug("Unable to set metadata credentials header", e);
                metadataApplier.fail(Status.UNAUTHENTICATED.withCause(e));
            }
        });
    }

    public void thisUsesUnstableApi() {
    }
}

