/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.StreamObserver;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.InputStream;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.grpc.GrpcAuthType;
import org.apache.camel.component.grpc.GrpcConfiguration;
import org.apache.camel.component.grpc.GrpcEndpoint;
import org.apache.camel.component.grpc.GrpcProducerStrategy;
import org.apache.camel.component.grpc.GrpcUtils;
import org.apache.camel.component.grpc.auth.jwt.JwtCallCredentials;
import org.apache.camel.component.grpc.auth.jwt.JwtHelper;
import org.apache.camel.component.grpc.client.GrpcExchangeForwarder;
import org.apache.camel.component.grpc.client.GrpcExchangeForwarderFactory;
import org.apache.camel.component.grpc.client.GrpcResponseAggregationStreamObserver;
import org.apache.camel.component.grpc.client.GrpcResponseRouterStreamObserver;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcProducer.class);
    protected final GrpcConfiguration configuration;
    protected final GrpcEndpoint endpoint;
    private ManagedChannel channel;
    private Object grpcStub;
    private GrpcExchangeForwarder forwarder;
    private StreamObserver<Object> globalResponseObserver;

    public GrpcProducer(GrpcEndpoint endpoint, GrpcConfiguration configuration) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.configuration = configuration;
        if (configuration.getProducerStrategy() == GrpcProducerStrategy.STREAMING) {
            if (configuration.isSynchronous()) {
                throw new IllegalStateException("Cannot use synchronous processing in streaming mode");
            }
            if (configuration.getStreamRepliesTo() == null) {
                throw new IllegalStateException("The streamReplyTo property is mandatory when using the STREAMING mode");
            }
        }
        if (configuration.getAuthenticationType() == GrpcAuthType.GOOGLE && configuration.getNegotiationType() != NegotiationType.TLS) {
            throw new IllegalStateException("Google token-based authentication requires SSL/TLS negotiation mode");
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        GrpcResponseAggregationStreamObserver streamObserver = this.globalResponseObserver;
        if (this.globalResponseObserver == null) {
            streamObserver = new GrpcResponseAggregationStreamObserver(exchange, callback);
        }
        return this.forwarder.forward(exchange, streamObserver, callback);
    }

    public void process(Exchange exchange) throws Exception {
        this.forwarder.forward(exchange);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.channel == null) {
            CallCredentials callCreds = null;
            this.initializeChannel();
            if (this.configuration.getAuthenticationType() == GrpcAuthType.GOOGLE) {
                ObjectHelper.notNull((Object)this.configuration.getKeyCertChainResource(), (String)"serviceAccountResource");
                GoogleCredentials creds = GoogleCredentials.fromStream((InputStream)ResourceHelper.resolveResourceAsInputStream((CamelContext)this.endpoint.getCamelContext(), (String)this.configuration.getServiceAccountResource()));
                callCreds = MoreCallCredentials.from((Credentials)creds);
            } else if (this.configuration.getAuthenticationType() == GrpcAuthType.JWT) {
                ObjectHelper.notNull((Object)this.configuration.getJwtSecret(), (String)"jwtSecret");
                String jwtToken = JwtHelper.createJwtToken(this.configuration.getJwtAlgorithm(), this.configuration.getJwtSecret(), this.configuration.getJwtIssuer(), this.configuration.getJwtSubject());
                callCreds = new JwtCallCredentials(jwtToken);
            }
            if (this.configuration.isSynchronous()) {
                LOG.debug("Getting synchronous method stub from channel");
                this.grpcStub = GrpcUtils.constructGrpcBlockingStub(this.endpoint.getServicePackage(), this.endpoint.getServiceName(), (Channel)this.channel, callCreds, this.endpoint.getCamelContext());
            } else {
                LOG.debug("Getting asynchronous method stub from channel");
                this.grpcStub = GrpcUtils.constructGrpcAsyncStub(this.endpoint.getServicePackage(), this.endpoint.getServiceName(), (Channel)this.channel, callCreds, this.endpoint.getCamelContext());
            }
            this.forwarder = GrpcExchangeForwarderFactory.createExchangeForwarder(this.configuration, this.grpcStub);
            if (this.configuration.getStreamRepliesTo() != null) {
                this.globalResponseObserver = new GrpcResponseRouterStreamObserver(this.configuration, this.getEndpoint());
            }
            if (this.globalResponseObserver != null) {
                ServiceHelper.startService(this.globalResponseObserver);
            }
        }
    }

    protected void doStop() throws Exception {
        if (this.globalResponseObserver != null) {
            ServiceHelper.stopService(this.globalResponseObserver);
        }
        if (this.channel != null) {
            this.forwarder.shutdown();
            this.forwarder = null;
            LOG.debug("Terminating channel to the remote gRPC server");
            this.channel.shutdown().shutdownNow();
            this.channel = null;
            this.grpcStub = null;
            this.globalResponseObserver = null;
        }
        super.doStop();
    }

    protected void initializeChannel() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getHost()) || ObjectHelper.isEmpty((Object)this.configuration.getPort())) {
            throw new IllegalArgumentException("No connection properties (host or port) specified");
        }
        LOG.info("Creating channel to the remote gRPC server {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress((String)this.configuration.getHost(), (int)this.configuration.getPort());
        if (this.configuration.getNegotiationType() == NegotiationType.TLS) {
            ObjectHelper.notNull((Object)this.configuration.getKeyCertChainResource(), (String)"keyCertChainResource");
            ObjectHelper.notNull((Object)this.configuration.getKeyResource(), (String)"keyResource");
            ClassResolver classResolver = this.endpoint.getCamelContext().getClassResolver();
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient().sslProvider(SslProvider.OPENSSL).keyManager(ResourceHelper.resolveResourceAsInputStream((CamelContext)this.endpoint.getCamelContext(), (String)this.configuration.getKeyCertChainResource()), ResourceHelper.resolveResourceAsInputStream((CamelContext)this.endpoint.getCamelContext(), (String)this.configuration.getKeyResource()), this.configuration.getKeyPassword());
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getTrustCertCollectionResource())) {
                sslContextBuilder = sslContextBuilder.trustManager(ResourceHelper.resolveResourceAsInputStream((CamelContext)this.endpoint.getCamelContext(), (String)this.configuration.getTrustCertCollectionResource()));
            }
            channelBuilder = channelBuilder.sslContext(sslContextBuilder.build());
        }
        this.channel = ((NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)channelBuilder.negotiationType(this.configuration.getNegotiationType()).flowControlWindow(this.configuration.getFlowControlWindow()).userAgent(this.configuration.getUserAgent())).maxInboundMessageSize(this.configuration.getMaxMessageSize())).intercept(this.configuration.getClientInterceptors())).build();
    }
}

