/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.groovy;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.codehaus.groovy.runtime.InvokerHelper;

public class GroovyScriptClassLoader
extends ClassLoader
implements Closeable {
    private final Map<String, Class<?>> classes = new HashMap();

    public GroovyScriptClassLoader() {
        super(GroovyScriptClassLoader.class.getClassLoader());
    }

    public GroovyScriptClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public String getName() {
        return "GroovyScriptClassLoader";
    }

    public void addClass(String name, Class<?> clazz) {
        this.classes.put(name, clazz);
    }

    public int size() {
        return this.classes.size();
    }

    public Set<String> getCompiledClassNames() {
        return new TreeSet<String>(this.classes.keySet());
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.classes.get(name);
        if (clazz != null) {
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.classes.get(name);
        if (clazz != null) {
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    public void removeClass(String name) {
        Class<?> clazz = this.classes.get(name);
        if (clazz != null) {
            InvokerHelper.removeClass(clazz);
        }
    }

    @Override
    public void close() throws IOException {
        this.clear();
    }

    void clear() {
        for (Class<?> clazz : this.classes.values()) {
            InvokerHelper.removeClass(clazz);
        }
        this.classes.clear();
    }
}

