/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.attachment.DefaultAttachmentMessage;
import org.apache.camel.language.groovy.GroovyLanguage;
import org.apache.camel.language.groovy.GroovyScriptClassLoader;
import org.apache.camel.language.groovy.GroovyShellFactory;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ExpressionSupport;
import org.apache.camel.support.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyExpression
extends ExpressionSupport {
    private static final Logger LOG = LoggerFactory.getLogger(GroovyExpression.class);
    private final String text;

    public GroovyExpression(String text) {
        this.text = text;
    }

    public String toString() {
        return "groovy: " + this.text;
    }

    protected String assertionFailureMessage(Exchange exchange) {
        return "groovy: " + this.text;
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        HashMap<String, Object> globalVariables = new HashMap<String, Object>();
        Script script = this.instantiateScript(exchange, globalVariables);
        script.setBinding(this.createBinding(exchange, globalVariables));
        Object value = script.run();
        return (T)exchange.getContext().getTypeConverter().convertTo(type, value);
    }

    protected Script instantiateScript(Exchange exchange, Map<String, Object> globalVariables) {
        String key;
        Class scriptClass;
        GroovyLanguage language = (GroovyLanguage)exchange.getContext().resolveLanguage("groovy");
        Set shellFactories = exchange.getContext().getRegistry().findByType(GroovyShellFactory.class);
        GroovyShellFactory shellFactory = null;
        String fileName = null;
        if (shellFactories.size() == 1) {
            shellFactory = (GroovyShellFactory)shellFactories.iterator().next();
            fileName = shellFactory.getFileName(exchange);
            globalVariables.putAll(shellFactory.getVariables(exchange));
        }
        if ((scriptClass = language.getScriptFromCache(key = fileName != null ? fileName + this.text : this.text)) == null) {
            ClassLoader cl = (ClassLoader)exchange.getContext().getCamelContextExtension().getContextPlugin(GroovyScriptClassLoader.class);
            GroovyShell shell = shellFactory != null ? shellFactory.createGroovyShell(exchange) : (cl != null ? new GroovyShell(cl) : new GroovyShell());
            scriptClass = fileName != null ? shell.getClassLoader().parseClass(this.text, fileName) : shell.getClassLoader().parseClass(this.text);
            language.addScriptToCache(key, scriptClass);
        }
        return (Script)ObjectHelper.newInstance(scriptClass, Script.class);
    }

    protected Binding createBinding(Exchange exchange, Map<String, Object> globalVariables) {
        HashMap<String, Object> map = new HashMap<String, Object>(globalVariables);
        ExchangeHelper.populateVariableMap((Exchange)exchange, map, (boolean)true);
        DefaultAttachmentMessage am = new DefaultAttachmentMessage(exchange.getMessage());
        if (am.hasAttachments()) {
            map.put("attachments", am.getAttachments());
        } else {
            map.put("attachments", Collections.EMPTY_MAP);
        }
        map.put("log", LOG);
        return new Binding(map);
    }
}

