/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.groovy.xml;

import groovy.util.Node;
import groovy.xml.XmlNodePrinter;
import groovy.xml.XmlParser;
import groovy.xml.XmlUtil;
import groovy.xml.slurpersupport.GPathResult;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StringHelper;

@Dataformat(value="groovyXml")
public class GroovyXmlDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private static final int START_TAG = 1;
    private static final int VALUE = 2;
    private static final int END_TAG = 3;
    private boolean attributeMapping = true;

    public boolean isAttributeMapping() {
        return this.attributeMapping;
    }

    public void setAttributeMapping(boolean attributeMapping) {
        this.attributeMapping = attributeMapping;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        if (graph instanceof GPathResult) {
            GPathResult gp = (GPathResult)graph;
            XmlUtil.serialize((GPathResult)gp, (OutputStream)stream);
        } else if (graph instanceof Node) {
            Node n = (Node)graph;
            this.serialize(n, stream);
        } else if (graph instanceof Map) {
            Map map = (Map)graph;
            this.serialize(exchange, map, stream);
        } else if (graph.getClass().getName().startsWith("com.fasterxml.jackson.databind")) {
            Map map = (Map)exchange.getContext().getTypeConverter().convertTo(Map.class, exchange, graph);
            this.serialize(exchange, map, stream);
        } else {
            byte[] arr = (byte[])exchange.getContext().getTypeConverter().mandatoryConvertTo(byte[].class, exchange, graph);
            stream.write(arr);
        }
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        XmlParser parser = new XmlParser();
        return parser.parse(stream);
    }

    public String getDataFormatName() {
        return "groovyXml";
    }

    private void serialize(Node node, OutputStream os) {
        PrintWriter pw = new PrintWriter(os);
        XmlNodePrinter nodePrinter = new XmlNodePrinter(pw);
        nodePrinter.setPreserveWhitespace(true);
        nodePrinter.print(node);
    }

    private void printLines(List<Line> lines, OutputStream os) throws Exception {
        lines.add(new Line(lines.get((int)0).key, null, 3, null));
        int level = 0;
        for (Line line : lines) {
            String pad;
            int kind = line.kind;
            if (kind == 1) {
                pad = StringHelper.padString((int)level);
                os.write(pad.getBytes());
                os.write("<".getBytes());
                os.write(line.key.getBytes());
                if (line.attrs != null) {
                    StringJoiner sj = new StringJoiner(" ");
                    for (Map.Entry<String, String> a : line.attrs.entrySet()) {
                        sj.add(a.getKey() + "=\"" + a.getValue() + "\"");
                    }
                    if (sj.length() > 0) {
                        os.write(" ".getBytes());
                        os.write(sj.toString().getBytes());
                    }
                }
                os.write(">\n".getBytes());
                ++level;
                continue;
            }
            if (kind == 3) {
                pad = StringHelper.padString((int)(--level));
                os.write(pad.getBytes());
                os.write("</".getBytes());
                os.write(line.key.getBytes());
                os.write(">\n".getBytes());
                continue;
            }
            pad = StringHelper.padString((int)level);
            os.write(pad.getBytes());
            os.write("<".getBytes());
            os.write(line.key.getBytes());
            os.write(">".getBytes());
            os.write(line.value.getBytes());
            os.write("</".getBytes());
            os.write(line.key.getBytes());
            os.write(">\n".getBytes());
        }
    }

    private void serialize(Exchange exchange, Map<String, Object> map, OutputStream os) throws Exception {
        ArrayList<Line> lines = new ArrayList<Line>();
        this.doSerialize(exchange.getContext(), map, lines);
        this.printLines(lines, os);
    }

    private void doSerialize(CamelContext context, Map<String, Object> map, List<Line> lines) {
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        if (this.attributeMapping) {
            for (String key : map.keySet()) {
                String val;
                if (!key.startsWith("_") && !key.startsWith("@") || (val = (String)context.getTypeConverter().convertTo(String.class, map.get(key))) == null || (val = val.trim()).isBlank()) continue;
                attrs.put(key.substring(1), val);
            }
        }
        boolean root = false;
        for (Map.Entry<String, Object> e : map.entrySet()) {
            Object updated;
            String key = e.getKey();
            if (key.startsWith("_") || key.startsWith("@")) continue;
            if (!attrs.isEmpty() && !lines.isEmpty()) {
                int pos = lines.size() - 1;
                Line prev = lines.get(pos);
                lines.remove(pos);
                updated = new Line(prev.key, prev.value, prev.kind, new LinkedHashMap<String, String>(attrs));
                lines.add((Line)updated);
                attrs.clear();
            }
            if (lines.isEmpty()) {
                root = true;
                lines.add(new Line(key, null, 1, null));
            }
            if (e.getValue() == null) continue;
            updated = e.getValue();
            if (updated instanceof Map) {
                Map cm = (Map)updated;
                this.doSerialize(context, cm, lines);
                continue;
            }
            updated = e.getValue();
            if (updated instanceof List) {
                List cl = (List)updated;
                this.doSerialize(context, cl, key, attrs, lines, root);
                continue;
            }
            String val = (String)context.getTypeConverter().convertTo(String.class, e.getValue());
            if (val == null || (val = val.trim()).isBlank()) continue;
            lines.add(new Line(key, val, 2, null));
        }
    }

    private void doSerialize(CamelContext context, List list, String key, Map<String, String> attrs, List<Line> lines, boolean root) {
        for (Object e : list) {
            if (!root) {
                lines.add(new Line(key, null, 1, attrs));
            }
            if (e instanceof Map) {
                Map map = (Map)e;
                this.doSerialize(context, map, lines);
            }
            if (root) continue;
            lines.add(new Line(key, null, 3, null));
        }
    }

    record Line(String key, String value, int kind, Map<String, String> attrs) {
    }
}

