/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.pubsublite;

import com.google.api.core.ApiService;
import com.google.cloud.pubsublite.cloudpubsub.Subscriber;
import com.google.common.base.Strings;
import com.google.pubsub.v1.ProjectSubscriptionName;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.google.pubsublite.GooglePubsubLiteEndpoint;
import org.apache.camel.component.google.pubsublite.consumer.CamelMessageReceiver;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GooglePubsubLiteConsumer
extends DefaultConsumer {
    private Logger localLog;
    private final GooglePubsubLiteEndpoint endpoint;
    private final Processor processor;
    private ExecutorService executor;
    private final List<Subscriber> subscribers;

    GooglePubsubLiteConsumer(GooglePubsubLiteEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.processor = processor;
        this.subscribers = Collections.synchronizedList(new LinkedList());
        String loggerId = endpoint.getLoggerId();
        if (Strings.isNullOrEmpty((String)loggerId)) {
            loggerId = ((Object)((Object)this)).getClass().getName();
        }
        this.localLog = LoggerFactory.getLogger((String)loggerId);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.localLog.info("Starting Google PubSub Lite consumer for {}/{}", (Object)this.endpoint.getProjectId(), (Object)this.endpoint.getDestinationName());
        this.executor = this.endpoint.createExecutor((Object)this);
        for (int i = 0; i < this.endpoint.getConcurrentConsumers(); ++i) {
            this.executor.submit(new SubscriberWrapper());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        super.doStop();
        this.localLog.info("Stopping Google PubSub Lite consumer for {}/{}", (Object)this.endpoint.getProjectId(), (Object)this.endpoint.getDestinationName());
        List<Subscriber> list = this.subscribers;
        synchronized (list) {
            if (!this.subscribers.isEmpty()) {
                this.localLog.info("Stopping subscribers for {}/{}", (Object)this.endpoint.getProjectId(), (Object)this.endpoint.getDestinationName());
                this.subscribers.forEach(ApiService::stopAsync);
            }
        }
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownGraceful(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    private class SubscriberWrapper
    implements Runnable {
        private final String subscriptionName;

        SubscriberWrapper() {
            this.subscriptionName = ProjectSubscriptionName.format((String)GooglePubsubLiteConsumer.this.endpoint.getProjectId().toString(), (String)GooglePubsubLiteConsumer.this.endpoint.getDestinationName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: {
                try {
                    if (GooglePubsubLiteConsumer.this.localLog.isDebugEnabled()) {
                        GooglePubsubLiteConsumer.this.localLog.debug("Subscribing to {}", (Object)this.subscriptionName);
                    }
                    while (GooglePubsubLiteConsumer.this.isRunAllowed() && !GooglePubsubLiteConsumer.this.isSuspendingOrSuspended()) {
                        CamelMessageReceiver messageReceiver = new CamelMessageReceiver(GooglePubsubLiteConsumer.this, GooglePubsubLiteConsumer.this.endpoint, GooglePubsubLiteConsumer.this.processor);
                        Subscriber subscriber = GooglePubsubLiteConsumer.this.endpoint.getComponent().getSubscriber(messageReceiver, GooglePubsubLiteConsumer.this.endpoint);
                        try {
                            GooglePubsubLiteConsumer.this.subscribers.add(subscriber);
                            subscriber.startAsync().awaitRunning();
                            subscriber.awaitTerminated();
                        }
                        catch (Exception e) {
                            GooglePubsubLiteConsumer.this.localLog.error("Failure getting messages from PubSub Lite", (Throwable)e);
                            if (!GooglePubsubLiteConsumer.this.endpoint.isBridgeErrorHandler()) continue;
                            GooglePubsubLiteConsumer.this.getExceptionHandler().handleException((Throwable)e);
                        }
                        finally {
                            GooglePubsubLiteConsumer.this.localLog.debug("Stopping async subscriber {}", (Object)this.subscriptionName);
                            subscriber.stopAsync();
                        }
                    }
                    GooglePubsubLiteConsumer.this.localLog.debug("Exit run for subscription {}", (Object)this.subscriptionName);
                }
                catch (Exception e) {
                    GooglePubsubLiteConsumer.this.localLog.error("Failure getting messages from PubSub Lite", (Throwable)e);
                    if (!GooglePubsubLiteConsumer.this.endpoint.isBridgeErrorHandler()) break block9;
                    GooglePubsubLiteConsumer.this.getExceptionHandler().handleException((Throwable)e);
                }
            }
        }
    }
}

