/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.pubsublite;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.stub.PublisherStubSettings;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.cloudpubsub.Publisher;
import com.google.cloud.pubsublite.cloudpubsub.PublisherSettings;
import com.google.cloud.pubsublite.cloudpubsub.Subscriber;
import com.google.cloud.pubsublite.cloudpubsub.SubscriberSettings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.google.pubsublite.GooglePubsubLiteEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="google-pubsub-lite")
public class GooglePubsubLiteComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(GooglePubsubLiteComponent.class);
    @Metadata(label="security", description="The Service account key that can be used as credentials for the PubSub Lite publisher/subscriber. It can be loaded by default from  classpath, but you can prefix with classpath:, file:, or http: to load the resource from different systems.")
    private String serviceAccountKey;
    @Metadata(label="producer,advanced", defaultValue="100", description="Maximum number of producers to cache. This could be increased if you have producers for lots of different topics.")
    private int publisherCacheSize = 100;
    @Metadata(label="producer,advanced", defaultValue="180000", description="How many milliseconds should each producer stay alive in the cache.")
    private int publisherCacheTimeout = 180000;
    @Metadata(label="consumer,advanced", defaultValue="10485760", description="The number of quota bytes that may be outstanding to the client. Must be greater than the allowed size of the largest message (1 MiB).")
    private long consumerBytesOutstanding = 0xA00000L;
    @Metadata(label="consumer,advanced", defaultValue="1000", description="The number of messages that may be outstanding to the client. Must be >0.")
    private long consumerMessagesOutstanding = 1000L;
    @Metadata(label="producer,advanced", defaultValue="60000", description="How many milliseconds should a producer be allowed to terminate.")
    private int publisherTerminationTimeout = 60000;
    private RemovalListener<String, Publisher> removalListener = removal -> {
        Publisher publisher = (Publisher)removal.getValue();
        if (ObjectHelper.isNotEmpty((Object)publisher)) {
            return;
        }
        publisher.stopAsync();
        try {
            publisher.awaitTerminated((long)this.publisherTerminationTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    };
    private Cache<String, Publisher> cachedPublishers = CacheBuilder.newBuilder().expireAfterWrite((long)this.publisherCacheTimeout, TimeUnit.MILLISECONDS).maximumSize((long)this.publisherCacheSize).removalListener(this.removalListener).build();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String[] parts = remaining.split(":");
        if (parts.length < 3) {
            throw new IllegalArgumentException("Google PubSub Lite Endpoint format \"projectId:location:destinationName[:subscriptionName]\"");
        }
        GooglePubsubLiteEndpoint pubsubEndpoint = new GooglePubsubLiteEndpoint(uri, (Component)this);
        LOG.debug("Google Cloud ProjectId {}", (Object)parts[0]);
        pubsubEndpoint.setProjectId(parts[0]);
        LOG.debug("Google Cloud LocationId {}", (Object)parts[1]);
        pubsubEndpoint.setLocation(parts[1]);
        LOG.debug("Google Cloud DestinationName {}", (Object)parts[2]);
        pubsubEndpoint.setDestinationName(parts[2]);
        LOG.debug("Google Cloud ServiceAccountKey {}", (Object)this.serviceAccountKey);
        pubsubEndpoint.setServiceAccountKey(this.serviceAccountKey);
        this.setProperties((Endpoint)pubsubEndpoint, parameters);
        return pubsubEndpoint;
    }

    protected void doShutdown() throws Exception {
        this.cachedPublishers.cleanUp();
        this.cachedPublishers.invalidateAll();
        super.doShutdown();
    }

    public Publisher getPublisher(String topicName, GooglePubsubLiteEndpoint googlePubsubEndpoint) throws ExecutionException {
        return (Publisher)this.cachedPublishers.get((Object)topicName, () -> this.buildPublisher(googlePubsubEndpoint));
    }

    private Publisher buildPublisher(GooglePubsubLiteEndpoint googlePubsubLiteEndpoint) throws IOException {
        TopicPath topicPath = TopicPath.parse((String)String.format("projects/%s/locations/%s/topics/%s", googlePubsubLiteEndpoint.getProjectId(), googlePubsubLiteEndpoint.getLocation(), googlePubsubLiteEndpoint.getDestinationName()));
        PublisherSettings publisherSettings = PublisherSettings.newBuilder().setTopicPath(topicPath).setCredentialsProvider(this.getCredentialsProvider(googlePubsubLiteEndpoint)).build();
        Publisher publisher = Publisher.create((PublisherSettings)publisherSettings);
        publisher.startAsync().awaitRunning();
        return publisher;
    }

    public Subscriber getSubscriber(MessageReceiver messageReceiver, GooglePubsubLiteEndpoint googlePubsubLiteEndpoint) throws IOException {
        SubscriptionPath subscriptionPath = SubscriptionPath.parse((String)String.format("projects/%s/locations/%s/subscriptions/%s", googlePubsubLiteEndpoint.getProjectId(), googlePubsubLiteEndpoint.getLocation(), googlePubsubLiteEndpoint.getDestinationName()));
        LOG.debug("ConsumerBytesOutstanding {}", (Object)this.consumerBytesOutstanding);
        LOG.debug("ConsumerMessagesOutstanding {}", (Object)this.consumerMessagesOutstanding);
        FlowControlSettings flowControlSettings = FlowControlSettings.builder().setBytesOutstanding(this.consumerBytesOutstanding).setMessagesOutstanding(this.consumerMessagesOutstanding).build();
        SubscriberSettings subscriberSettings = SubscriberSettings.newBuilder().setSubscriptionPath(subscriptionPath).setReceiver(messageReceiver).setPerPartitionFlowControlSettings(flowControlSettings).setCredentialsProvider(this.getCredentialsProvider(googlePubsubLiteEndpoint)).build();
        return Subscriber.create((SubscriberSettings)subscriberSettings);
    }

    private CredentialsProvider getCredentialsProvider(GooglePubsubLiteEndpoint endpoint) throws IOException {
        return FixedCredentialsProvider.create((Credentials)(ObjectHelper.isEmpty((String)endpoint.getServiceAccountKey()) ? GoogleCredentials.getApplicationDefault() : ServiceAccountCredentials.fromStream((InputStream)ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)endpoint.getServiceAccountKey())).createScoped((Collection)PublisherStubSettings.getDefaultServiceScopes())));
    }

    public int getPublisherCacheSize() {
        return this.publisherCacheSize;
    }

    public void setPublisherCacheSize(int publisherCacheSize) {
        this.publisherCacheSize = publisherCacheSize;
    }

    public int getPublisherCacheTimeout() {
        return this.publisherCacheTimeout;
    }

    public void setPublisherCacheTimeout(int publisherCacheTimeout) {
        this.publisherCacheTimeout = publisherCacheTimeout;
    }

    public int getPublisherTerminationTimeout() {
        return this.publisherTerminationTimeout;
    }

    public void setPublisherTerminationTimeout(int publisherTerminationTimeout) {
        this.publisherTerminationTimeout = publisherTerminationTimeout;
    }

    public String getServiceAccountKey() {
        return this.serviceAccountKey;
    }

    public void setServiceAccountKey(String serviceAccountKey) {
        this.serviceAccountKey = serviceAccountKey;
    }

    public long getConsumerBytesOutstanding() {
        return this.consumerBytesOutstanding;
    }

    public void setConsumerBytesOutstanding(long consumerBytesOutstanding) {
        this.consumerBytesOutstanding = consumerBytesOutstanding;
    }

    public long getConsumerMessagesOutstanding() {
        return this.consumerMessagesOutstanding;
    }

    public void setConsumerMessagesOutstanding(long consumerMessagesOutstanding) {
        this.consumerMessagesOutstanding = consumerMessagesOutstanding;
    }
}

