/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.mail;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class GoogleMailEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":apiName/methodName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Map<String, String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "google-mail".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "apiName", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "methodName", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Map<String, String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(53);
        props.add("accessToken");
        props.add("apiName");
        props.add("applicationName");
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("batchDeleteMessagesRequest");
        props.add("batchModifyMessagesRequest");
        props.add("bridgeErrorHandler");
        props.add("clientId");
        props.add("clientSecret");
        props.add("content");
        props.add("delay");
        props.add("delegate");
        props.add("deleted");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("format");
        props.add("greedy");
        props.add("historyTypes");
        props.add("id");
        props.add("inBody");
        props.add("includeSpamTrash");
        props.add("initialDelay");
        props.add("internalDateSource");
        props.add("labelId");
        props.add("labelIds");
        props.add("lazyStartProducer");
        props.add("maxResults");
        props.add("mediaContent");
        props.add("messageId");
        props.add("metadataHeaders");
        props.add("methodName");
        props.add("modifyMessageRequest");
        props.add("neverMarkSpam");
        props.add("pageToken");
        props.add("pollStrategy");
        props.add("processForCalendar");
        props.add("q");
        props.add("refreshToken");
        props.add("repeatCount");
        props.add("runLoggingLevel");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("scopes");
        props.add("sendEmptyMessageWhenIdle");
        props.add("serviceAccountKey");
        props.add("startHistoryId");
        props.add("startScheduler");
        props.add("timeUnit");
        props.add("useFixedDelay");
        props.add("userId");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(3);
        secretProps.add("accessToken");
        secretProps.add("clientSecret");
        secretProps.add("refreshToken");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashMap<String, String> prefixes = new HashMap<String, String>(1);
        prefixes.put("schedulerProperties", "scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableMap(prefixes);
    }
}

