/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.drive;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.services.drive.model.Channel;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.ModifyLabelsRequest;
import org.apache.camel.component.google.drive.GoogleDriveConfiguration;
import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@ApiParams(apiName="drive-files", description="The files collection of methods", apiMethods={@ApiMethod(methodName="copy", description="Creates a copy of a file and applies any requested updates with patch semantics", signatures={"com.google.api.services.drive.Drive$Files$Copy copy(String fileId, com.google.api.services.drive.model.File content)"}), @ApiMethod(methodName="create", description="Creates a new file", signatures={"com.google.api.services.drive.Drive$Files$Create create(com.google.api.services.drive.model.File content)", "com.google.api.services.drive.Drive$Files$Create create(com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent)"}), @ApiMethod(methodName="delete", description="Permanently deletes a file owned by the user without moving it to the trash", signatures={"com.google.api.services.drive.Drive$Files$Delete delete(String fileId)"}), @ApiMethod(methodName="download", description="Downloads content of a file", signatures={"com.google.api.services.drive.Drive$Files$Download download(String fileId)"}), @ApiMethod(methodName="emptyTrash", description="Permanently deletes all of the user's trashed files", signatures={"com.google.api.services.drive.Drive$Files$EmptyTrash emptyTrash()"}), @ApiMethod(methodName="export", description="Exports a Google Workspace document to the requested MIME type and returns exported byte content", signatures={"com.google.api.services.drive.Drive$Files$Export export(String fileId, String mimeType)"}), @ApiMethod(methodName="generateIds", description="Generates a set of file IDs which can be provided in create or copy requests", signatures={"com.google.api.services.drive.Drive$Files$GenerateIds generateIds()"}), @ApiMethod(methodName="get", description="Gets a file's metadata or content by ID", signatures={"com.google.api.services.drive.Drive$Files$Get get(String fileId)"}), @ApiMethod(methodName="list", description="Lists the user's files", signatures={"com.google.api.services.drive.Drive$Files$List list()"}), @ApiMethod(methodName="listLabels", description="Lists the labels on a file", signatures={"com.google.api.services.drive.Drive$Files$ListLabels listLabels(String fileId)"}), @ApiMethod(methodName="modifyLabels", description="Modifies the set of labels applied to a file", signatures={"com.google.api.services.drive.Drive$Files$ModifyLabels modifyLabels(String fileId, com.google.api.services.drive.model.ModifyLabelsRequest content)"}), @ApiMethod(methodName="update", description="Updates a file's metadata and/or content", signatures={"com.google.api.services.drive.Drive$Files$Update update(String fileId, com.google.api.services.drive.model.File content)", "com.google.api.services.drive.Drive$Files$Update update(String fileId, com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent)"}), @ApiMethod(methodName="watch", description="Subscribes to changes to a file", signatures={"com.google.api.services.drive.Drive$Files$Watch watch(String fileId, com.google.api.services.drive.model.Channel content)"})}, aliases={})
@UriParams
@Configurer(extended=true)
public final class DriveFilesEndpointConfiguration
extends GoogleDriveConfiguration {
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="get", description="Whether the user is acknowledging the risk of downloading known malware or other abusive files"), @ApiMethod(methodName="watch", description="Whether the user is acknowledging the risk of downloading known malware or other abusive files")})
    private Boolean acknowledgeAbuse;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="update", description="A comma-separated list of parent IDs to add")})
    private String addParents;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="watch", description="The com.google.api.services.drive.model.Channel")})
    private Channel channel;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="create", description="The com.google.api.services.drive.model.File media metadata or null if none")})
    private File content;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Bodies of items (files/documents) to which the query applies")})
    private String corpora;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Deprecated: The source of files to list")})
    @Deprecated
    private String corpus;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="generateIds", description="The number of IDs to return")})
    private Integer count;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="emptyTrash", description="If set, empties the trash of the provided shared drive"), @ApiMethod(methodName="list", description="ID of the shared drive to search")})
    private String driveId;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="copy", description="Deprecated"), @ApiMethod(methodName="create", description="Deprecated"), @ApiMethod(methodName="delete", description="Deprecated: If an item is not in a shared drive and its last parent is deleted but the item itself is not, the item will be placed under its owner's root"), @ApiMethod(methodName="emptyTrash", description="Deprecated: If an item is not in a shared drive and its last parent is deleted but the item itself is not, the item will be placed under its owner's root"), @ApiMethod(methodName="update", description="Deprecated: Adding files to multiple folders is no longer supported")})
    private Boolean enforceSingleParent;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="copy", description="The com.google.api.services.drive.model.File"), @ApiMethod(methodName="update", description="The com.google.api.services.drive.model.File media metadata or null if none")})
    private File file;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="copy", description="The ID of the file"), @ApiMethod(methodName="delete", description="The ID of the file"), @ApiMethod(methodName="download", description="Required. The ID of the file to download."), @ApiMethod(methodName="export", description="The ID of the file"), @ApiMethod(methodName="get", description="The ID of the file"), @ApiMethod(methodName="listLabels", description="The ID for the file"), @ApiMethod(methodName="modifyLabels", description="The ID of the file to which the labels belong"), @ApiMethod(methodName="update", description="The ID of the file"), @ApiMethod(methodName="watch", description="The ID of the file")})
    private String fileId;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="copy", description="Whether to ignore the domain's default visibility settings for the created file"), @ApiMethod(methodName="create", description="Whether to ignore the domain's default visibility settings for the created file")})
    private Boolean ignoreDefaultVisibility;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Whether both My Drive and shared drive items should be included in results")})
    private Boolean includeItemsFromAllDrives;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="copy", description="A comma-separated list of IDs of labels to include in the labelInfo part of the response"), @ApiMethod(methodName="create", description="A comma-separated list of IDs of labels to include in the labelInfo part of the response"), @ApiMethod(methodName="get", description="A comma-separated list of IDs of labels to include in the labelInfo part of the response"), @ApiMethod(methodName="list", description="A comma-separated list of IDs of labels to include in the labelInfo part of the response"), @ApiMethod(methodName="update", description="A comma-separated list of IDs of labels to include in the labelInfo part of the response"), @ApiMethod(methodName="watch", description="A comma-separated list of IDs of labels to include in the labelInfo part of the response")})
    private String includeLabels;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="copy", description="Specifies which additional view's permissions to include in the response"), @ApiMethod(methodName="create", description="Specifies which additional view's permissions to include in the response"), @ApiMethod(methodName="get", description="Specifies which additional view's permissions to include in the response"), @ApiMethod(methodName="list", description="Specifies which additional view's permissions to include in the response"), @ApiMethod(methodName="update", description="Specifies which additional view's permissions to include in the response"), @ApiMethod(methodName="watch", description="Specifies which additional view's permissions to include in the response")})
    private String includePermissionsForView;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Deprecated: Use includeItemsFromAllDrives instead")})
    @Deprecated
    private Boolean includeTeamDriveItems;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="copy", description="Whether to set the 'keepForever' field in the new head revision"), @ApiMethod(methodName="create", description="Whether to set the 'keepForever' field in the new head revision"), @ApiMethod(methodName="update", description="Whether to set the 'keepForever' field in the new head revision")})
    private Boolean keepRevisionForever;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="listLabels", description="The maximum number of labels to return per page")})
    private Integer maxResults;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="create", description="The media HTTP content"), @ApiMethod(methodName="update", description="The media HTTP content")})
    private AbstractInputStreamContent mediaContent;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="download", description="Optional"), @ApiMethod(methodName="export", description="Required. The MIME type of the format requested for this export.")})
    private String mimeType;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="modifyLabels", description="The com.google.api.services.drive.model.ModifyLabelsRequest")})
    private ModifyLabelsRequest modifyLabelsRequest;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="copy", description="A language hint for OCR processing during image import (ISO 639-1 code)"), @ApiMethod(methodName="create", description="A language hint for OCR processing during image import (ISO 639-1 code)"), @ApiMethod(methodName="update", description="A language hint for OCR processing during image import (ISO 639-1 code)")})
    private String ocrLanguage;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="A comma-separated list of sort keys")})
    private String orderBy;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="The maximum number of files to return per page")})
    private Integer pageSize;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="The token for continuing a previous list request on the next page"), @ApiMethod(methodName="listLabels", description="The token for continuing a previous list request on the next page")})
    private String pageToken;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="A query for filtering the file results")})
    private String q;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="update", description="A comma-separated list of parent IDs to remove")})
    private String removeParents;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="download", description="Optional")})
    private String revisionId;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="generateIds", description="The space in which the IDs can be used to create new files")})
    private String space;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="A comma-separated list of spaces to query within the corpora")})
    private String spaces;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="copy", description="Whether the requesting application supports both My Drives and shared drives"), @ApiMethod(methodName="create", description="Whether the requesting application supports both My Drives and shared drives"), @ApiMethod(methodName="delete", description="Whether the requesting application supports both My Drives and shared drives"), @ApiMethod(methodName="get", description="Whether the requesting application supports both My Drives and shared drives"), @ApiMethod(methodName="list", description="Whether the requesting application supports both My Drives and shared drives"), @ApiMethod(methodName="update", description="Whether the requesting application supports both My Drives and shared drives"), @ApiMethod(methodName="watch", description="Whether the requesting application supports both My Drives and shared drives")})
    private Boolean supportsAllDrives;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="copy", description="Deprecated: Use supportsAllDrives instead"), @ApiMethod(methodName="create", description="Deprecated: Use supportsAllDrives instead"), @ApiMethod(methodName="delete", description="Deprecated: Use supportsAllDrives instead"), @ApiMethod(methodName="get", description="Deprecated: Use supportsAllDrives instead"), @ApiMethod(methodName="list", description="Deprecated: Use supportsAllDrives instead"), @ApiMethod(methodName="update", description="Deprecated: Use supportsAllDrives instead"), @ApiMethod(methodName="watch", description="Deprecated: Use supportsAllDrives instead")})
    @Deprecated
    private Boolean supportsTeamDrives;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Deprecated: Use driveId instead")})
    @Deprecated
    private String teamDriveId;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="generateIds", description="The type of items which the IDs can be used for")})
    private String type;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="create", description="Whether to use the uploaded content as indexable text"), @ApiMethod(methodName="update", description="Whether to use the uploaded content as indexable text")})
    private Boolean useContentAsIndexableText;

    public Boolean getAcknowledgeAbuse() {
        return this.acknowledgeAbuse;
    }

    public void setAcknowledgeAbuse(Boolean acknowledgeAbuse) {
        this.acknowledgeAbuse = acknowledgeAbuse;
    }

    public String getAddParents() {
        return this.addParents;
    }

    public void setAddParents(String addParents) {
        this.addParents = addParents;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public File getContent() {
        return this.content;
    }

    public void setContent(File content) {
        this.content = content;
    }

    public String getCorpora() {
        return this.corpora;
    }

    public void setCorpora(String corpora) {
        this.corpora = corpora;
    }

    public String getCorpus() {
        return this.corpus;
    }

    public void setCorpus(String corpus) {
        this.corpus = corpus;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public String getDriveId() {
        return this.driveId;
    }

    public void setDriveId(String driveId) {
        this.driveId = driveId;
    }

    public Boolean getEnforceSingleParent() {
        return this.enforceSingleParent;
    }

    public void setEnforceSingleParent(Boolean enforceSingleParent) {
        this.enforceSingleParent = enforceSingleParent;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public Boolean getIgnoreDefaultVisibility() {
        return this.ignoreDefaultVisibility;
    }

    public void setIgnoreDefaultVisibility(Boolean ignoreDefaultVisibility) {
        this.ignoreDefaultVisibility = ignoreDefaultVisibility;
    }

    public Boolean getIncludeItemsFromAllDrives() {
        return this.includeItemsFromAllDrives;
    }

    public void setIncludeItemsFromAllDrives(Boolean includeItemsFromAllDrives) {
        this.includeItemsFromAllDrives = includeItemsFromAllDrives;
    }

    public String getIncludeLabels() {
        return this.includeLabels;
    }

    public void setIncludeLabels(String includeLabels) {
        this.includeLabels = includeLabels;
    }

    public String getIncludePermissionsForView() {
        return this.includePermissionsForView;
    }

    public void setIncludePermissionsForView(String includePermissionsForView) {
        this.includePermissionsForView = includePermissionsForView;
    }

    public Boolean getIncludeTeamDriveItems() {
        return this.includeTeamDriveItems;
    }

    public void setIncludeTeamDriveItems(Boolean includeTeamDriveItems) {
        this.includeTeamDriveItems = includeTeamDriveItems;
    }

    public Boolean getKeepRevisionForever() {
        return this.keepRevisionForever;
    }

    public void setKeepRevisionForever(Boolean keepRevisionForever) {
        this.keepRevisionForever = keepRevisionForever;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public AbstractInputStreamContent getMediaContent() {
        return this.mediaContent;
    }

    public void setMediaContent(AbstractInputStreamContent mediaContent) {
        this.mediaContent = mediaContent;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public ModifyLabelsRequest getModifyLabelsRequest() {
        return this.modifyLabelsRequest;
    }

    public void setModifyLabelsRequest(ModifyLabelsRequest modifyLabelsRequest) {
        this.modifyLabelsRequest = modifyLabelsRequest;
    }

    public String getOcrLanguage() {
        return this.ocrLanguage;
    }

    public void setOcrLanguage(String ocrLanguage) {
        this.ocrLanguage = ocrLanguage;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public String getRemoveParents() {
        return this.removeParents;
    }

    public void setRemoveParents(String removeParents) {
        this.removeParents = removeParents;
    }

    public String getRevisionId() {
        return this.revisionId;
    }

    public void setRevisionId(String revisionId) {
        this.revisionId = revisionId;
    }

    public String getSpace() {
        return this.space;
    }

    public void setSpace(String space) {
        this.space = space;
    }

    public String getSpaces() {
        return this.spaces;
    }

    public void setSpaces(String spaces) {
        this.spaces = spaces;
    }

    public Boolean getSupportsAllDrives() {
        return this.supportsAllDrives;
    }

    public void setSupportsAllDrives(Boolean supportsAllDrives) {
        this.supportsAllDrives = supportsAllDrives;
    }

    public Boolean getSupportsTeamDrives() {
        return this.supportsTeamDrives;
    }

    public void setSupportsTeamDrives(Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
    }

    public String getTeamDriveId() {
        return this.teamDriveId;
    }

    public void setTeamDriveId(String teamDriveId) {
        this.teamDriveId = teamDriveId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean getUseContentAsIndexableText() {
        return this.useContentAsIndexableText;
    }

    public void setUseContentAsIndexableText(Boolean useContentAsIndexableText) {
        this.useContentAsIndexableText = useContentAsIndexableText;
    }
}

