/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.calendar;

import com.google.api.client.util.DateTime;
import com.google.api.services.calendar.model.Channel;
import com.google.api.services.calendar.model.Event;
import java.util.List;
import org.apache.camel.component.google.calendar.GoogleCalendarConfiguration;
import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@ApiParams(apiName="events", description="The events collection of methods", apiMethods={@ApiMethod(methodName="calendarImport", description="Imports an event", signatures={"com.google.api.services.calendar.Calendar$Events$CalendarImport calendarImport(String calendarId, com.google.api.services.calendar.model.Event content)"}), @ApiMethod(methodName="delete", description="Deletes an event", signatures={"com.google.api.services.calendar.Calendar$Events$Delete delete(String calendarId, String eventId)"}), @ApiMethod(methodName="get", description="Returns an event based on its Google Calendar ID", signatures={"com.google.api.services.calendar.Calendar$Events$Get get(String calendarId, String eventId)"}), @ApiMethod(methodName="insert", description="Creates an event", signatures={"com.google.api.services.calendar.Calendar$Events$Insert insert(String calendarId, com.google.api.services.calendar.model.Event content)"}), @ApiMethod(methodName="instances", description="Returns instances of the specified recurring event", signatures={"com.google.api.services.calendar.Calendar$Events$Instances instances(String calendarId, String eventId)"}), @ApiMethod(methodName="list", description="Returns events on the specified calendar", signatures={"com.google.api.services.calendar.Calendar$Events$List list(String calendarId)"}), @ApiMethod(methodName="move", description="Moves an event to another calendar, i", signatures={"com.google.api.services.calendar.Calendar$Events$Move move(String calendarId, String eventId, String destination)"}), @ApiMethod(methodName="patch", description="Updates an event", signatures={"com.google.api.services.calendar.Calendar$Events$Patch patch(String calendarId, String eventId, com.google.api.services.calendar.model.Event content)"}), @ApiMethod(methodName="quickAdd", description="Creates an event based on a simple text string", signatures={"com.google.api.services.calendar.Calendar$Events$QuickAdd quickAdd(String calendarId, String text)"}), @ApiMethod(methodName="update", description="Updates an event", signatures={"com.google.api.services.calendar.Calendar$Events$Update update(String calendarId, String eventId, com.google.api.services.calendar.model.Event content)"}), @ApiMethod(methodName="watch", description="Watch for changes to Events resources", signatures={"com.google.api.services.calendar.Calendar$Events$Watch watch(String calendarId, com.google.api.services.calendar.model.Channel content)"})}, aliases={})
@UriParams
@Configurer(extended=true)
public final class CalendarEventsEndpointConfiguration
extends GoogleCalendarConfiguration {
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="get", description="Deprecated and ignored"), @ApiMethod(methodName="instances", description="Deprecated and ignored"), @ApiMethod(methodName="list", description="Deprecated and ignored"), @ApiMethod(methodName="patch", description="Deprecated and ignored"), @ApiMethod(methodName="update", description="Deprecated and ignored"), @ApiMethod(methodName="watch", description="Deprecated and ignored")})
    private Boolean alwaysIncludeEmail;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="calendarImport", description="Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to access the primary calendar of the currently logged in user, use the primary keyword."), @ApiMethod(methodName="delete", description="Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to access the primary calendar of the currently logged in user, use the primary keyword."), @ApiMethod(methodName="get", description="Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to access the primary calendar of the currently logged in user, use the primary keyword."), @ApiMethod(methodName="insert", description="Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to access the primary calendar of the currently logged in user, use the primary keyword."), @ApiMethod(methodName="instances", description="Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to access the primary calendar of the currently logged in user, use the primary keyword."), @ApiMethod(methodName="list", description="Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to access the primary calendar of the currently logged in user, use the primary keyword."), @ApiMethod(methodName="move", description="Calendar identifier of the source calendar where the event currently is on"), @ApiMethod(methodName="patch", description="Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to access the primary calendar of the currently logged in user, use the primary keyword."), @ApiMethod(methodName="quickAdd", description="Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to access the primary calendar of the currently logged in user, use the primary keyword."), @ApiMethod(methodName="update", description="Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to access the primary calendar of the currently logged in user, use the primary keyword."), @ApiMethod(methodName="watch", description="Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to access the primary calendar of the currently logged in user, use the primary keyword.")})
    private String calendarId;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="calendarImport", description="Version number of conference data supported by the API client"), @ApiMethod(methodName="insert", description="Version number of conference data supported by the API client"), @ApiMethod(methodName="patch", description="Version number of conference data supported by the API client"), @ApiMethod(methodName="update", description="Version number of conference data supported by the API client")})
    private Integer conferenceDataVersion;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="calendarImport", description="The com.google.api.services.calendar.model.Event"), @ApiMethod(methodName="insert", description="The com.google.api.services.calendar.model.Event"), @ApiMethod(methodName="patch", description="The com.google.api.services.calendar.model.Event"), @ApiMethod(methodName="update", description="The com.google.api.services.calendar.model.Event")})
    private Event content;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="watch", description="The com.google.api.services.calendar.model.Channel")})
    private Channel contentChannel;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="move", description="Calendar identifier of the target calendar where the event is to be moved to")})
    private String destination;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="delete", description="Event identifier"), @ApiMethod(methodName="get", description="Event identifier"), @ApiMethod(methodName="instances", description="Recurring event identifier"), @ApiMethod(methodName="move", description="Event identifier"), @ApiMethod(methodName="patch", description="Event identifier"), @ApiMethod(methodName="update", description="Event identifier")})
    private String eventId;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Event types to return"), @ApiMethod(methodName="watch", description="Event types to return")})
    private List eventTypes;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Specifies an event ID in the iCalendar format to be provided in the response"), @ApiMethod(methodName="watch", description="Specifies an event ID in the iCalendar format to be provided in the response")})
    private String iCalUID;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="get", description="The maximum number of attendees to include in the response"), @ApiMethod(methodName="insert", description="The maximum number of attendees to include in the response"), @ApiMethod(methodName="instances", description="The maximum number of attendees to include in the response"), @ApiMethod(methodName="list", description="The maximum number of attendees to include in the response"), @ApiMethod(methodName="patch", description="The maximum number of attendees to include in the response"), @ApiMethod(methodName="update", description="The maximum number of attendees to include in the response"), @ApiMethod(methodName="watch", description="The maximum number of attendees to include in the response")})
    private Integer maxAttendees;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="instances", description="Maximum number of events returned on one result page"), @ApiMethod(methodName="list", description="Maximum number of events returned on one result page"), @ApiMethod(methodName="watch", description="Maximum number of events returned on one result page")})
    private Integer maxResults;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="The order of the events returned in the result"), @ApiMethod(methodName="watch", description="The order of the events returned in the result")})
    private String orderBy;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="instances", description="The original start time of the instance in the result")})
    private String originalStart;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="instances", description="Token specifying which result page to return"), @ApiMethod(methodName="list", description="Token specifying which result page to return"), @ApiMethod(methodName="watch", description="Token specifying which result page to return")})
    private String pageToken;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Extended properties constraint specified as propertyName=value"), @ApiMethod(methodName="watch", description="Extended properties constraint specified as propertyName=value")})
    private List privateExtendedProperty;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Free text search terms to find events that match these terms in the following fields: - summary - description - location - attendee's displayName - attendee's email - organizer's displayName - organizer's email - workingLocationProperties"), @ApiMethod(methodName="watch", description="Free text search terms to find events that match these terms in the following fields: - summary - description - location - attendee's displayName - attendee's email - organizer's displayName - organizer's email - workingLocationProperties")})
    private String q;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="delete", description="Deprecated"), @ApiMethod(methodName="insert", description="Deprecated"), @ApiMethod(methodName="move", description="Deprecated"), @ApiMethod(methodName="patch", description="Deprecated"), @ApiMethod(methodName="quickAdd", description="Deprecated"), @ApiMethod(methodName="update", description="Deprecated")})
    private Boolean sendNotifications;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="delete", description="Guests who should receive notifications about the deletion of the event"), @ApiMethod(methodName="insert", description="Whether to send notifications about the creation of the new event"), @ApiMethod(methodName="move", description="Guests who should receive notifications about the change of the event's organizer"), @ApiMethod(methodName="patch", description="Guests who should receive notifications about the event update (for example, title changes, etc"), @ApiMethod(methodName="quickAdd", description="Guests who should receive notifications about the creation of the new event"), @ApiMethod(methodName="update", description="Guests who should receive notifications about the event update (for example, title changes, etc")})
    private String sendUpdates;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Extended properties constraint specified as propertyName=value"), @ApiMethod(methodName="watch", description="Extended properties constraint specified as propertyName=value")})
    private List sharedExtendedProperty;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="instances", description="Whether to include deleted events (with status equals cancelled) in the result"), @ApiMethod(methodName="list", description="Whether to include deleted events (with status equals cancelled) in the result"), @ApiMethod(methodName="watch", description="Whether to include deleted events (with status equals cancelled) in the result")})
    private Boolean showDeleted;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Whether to include hidden invitations in the result"), @ApiMethod(methodName="watch", description="Whether to include hidden invitations in the result")})
    private Boolean showHiddenInvitations;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Whether to expand recurring events into instances and only return single one-off events and instances of recurring events, but not the underlying recurring events themselves"), @ApiMethod(methodName="watch", description="Whether to expand recurring events into instances and only return single one-off events and instances of recurring events, but not the underlying recurring events themselves")})
    private Boolean singleEvents;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="calendarImport", description="Whether API client performing operation supports event attachments"), @ApiMethod(methodName="insert", description="Whether API client performing operation supports event attachments"), @ApiMethod(methodName="patch", description="Whether API client performing operation supports event attachments"), @ApiMethod(methodName="update", description="Whether API client performing operation supports event attachments")})
    private Boolean supportsAttachments;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Token obtained from the nextSyncToken field returned on the last page of results from the previous list request"), @ApiMethod(methodName="watch", description="Token obtained from the nextSyncToken field returned on the last page of results from the previous list request")})
    private String syncToken;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="quickAdd", description="The text describing the event to be created")})
    private String text;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="instances", description="Upper bound (exclusive) for an event's start time to filter by"), @ApiMethod(methodName="list", description="Upper bound (exclusive) for an event's start time to filter by"), @ApiMethod(methodName="watch", description="Upper bound (exclusive) for an event's start time to filter by")})
    private DateTime timeMax;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="instances", description="Lower bound (inclusive) for an event's end time to filter by"), @ApiMethod(methodName="list", description="Lower bound (exclusive) for an event's end time to filter by"), @ApiMethod(methodName="watch", description="Lower bound (exclusive) for an event's end time to filter by")})
    private DateTime timeMin;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="get", description="Time zone used in the response"), @ApiMethod(methodName="instances", description="Time zone used in the response"), @ApiMethod(methodName="list", description="Time zone used in the response"), @ApiMethod(methodName="watch", description="Time zone used in the response")})
    private String timeZone;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Lower bound for an event's last modification time (as a RFC3339 timestamp) to filter by"), @ApiMethod(methodName="watch", description="Lower bound for an event's last modification time (as a RFC3339 timestamp) to filter by")})
    private DateTime updatedMin;

    public Boolean getAlwaysIncludeEmail() {
        return this.alwaysIncludeEmail;
    }

    public void setAlwaysIncludeEmail(Boolean alwaysIncludeEmail) {
        this.alwaysIncludeEmail = alwaysIncludeEmail;
    }

    public String getCalendarId() {
        return this.calendarId;
    }

    public void setCalendarId(String calendarId) {
        this.calendarId = calendarId;
    }

    public Integer getConferenceDataVersion() {
        return this.conferenceDataVersion;
    }

    public void setConferenceDataVersion(Integer conferenceDataVersion) {
        this.conferenceDataVersion = conferenceDataVersion;
    }

    public Event getContent() {
        return this.content;
    }

    public void setContent(Event content) {
        this.content = content;
    }

    public Channel getContentChannel() {
        return this.contentChannel;
    }

    public void setContentChannel(Channel contentChannel) {
        this.contentChannel = contentChannel;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public List getEventTypes() {
        return this.eventTypes;
    }

    public void setEventTypes(List eventTypes) {
        this.eventTypes = eventTypes;
    }

    public String getICalUID() {
        return this.iCalUID;
    }

    public void setICalUID(String iCalUID) {
        this.iCalUID = iCalUID;
    }

    public Integer getMaxAttendees() {
        return this.maxAttendees;
    }

    public void setMaxAttendees(Integer maxAttendees) {
        this.maxAttendees = maxAttendees;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getOriginalStart() {
        return this.originalStart;
    }

    public void setOriginalStart(String originalStart) {
        this.originalStart = originalStart;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public List getPrivateExtendedProperty() {
        return this.privateExtendedProperty;
    }

    public void setPrivateExtendedProperty(List privateExtendedProperty) {
        this.privateExtendedProperty = privateExtendedProperty;
    }

    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public Boolean getSendNotifications() {
        return this.sendNotifications;
    }

    public void setSendNotifications(Boolean sendNotifications) {
        this.sendNotifications = sendNotifications;
    }

    public String getSendUpdates() {
        return this.sendUpdates;
    }

    public void setSendUpdates(String sendUpdates) {
        this.sendUpdates = sendUpdates;
    }

    public List getSharedExtendedProperty() {
        return this.sharedExtendedProperty;
    }

    public void setSharedExtendedProperty(List sharedExtendedProperty) {
        this.sharedExtendedProperty = sharedExtendedProperty;
    }

    public Boolean getShowDeleted() {
        return this.showDeleted;
    }

    public void setShowDeleted(Boolean showDeleted) {
        this.showDeleted = showDeleted;
    }

    public Boolean getShowHiddenInvitations() {
        return this.showHiddenInvitations;
    }

    public void setShowHiddenInvitations(Boolean showHiddenInvitations) {
        this.showHiddenInvitations = showHiddenInvitations;
    }

    public Boolean getSingleEvents() {
        return this.singleEvents;
    }

    public void setSingleEvents(Boolean singleEvents) {
        this.singleEvents = singleEvents;
    }

    public Boolean getSupportsAttachments() {
        return this.supportsAttachments;
    }

    public void setSupportsAttachments(Boolean supportsAttachments) {
        this.supportsAttachments = supportsAttachments;
    }

    public String getSyncToken() {
        return this.syncToken;
    }

    public void setSyncToken(String syncToken) {
        this.syncToken = syncToken;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public DateTime getTimeMax() {
        return this.timeMax;
    }

    public void setTimeMax(DateTime timeMax) {
        this.timeMax = timeMax;
    }

    public DateTime getTimeMin() {
        return this.timeMin;
    }

    public void setTimeMin(DateTime timeMin) {
        this.timeMin = timeMin;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public DateTime getUpdatedMin() {
        return this.updatedMin;
    }

    public void setUpdatedMin(DateTime updatedMin) {
        this.updatedMin = updatedMin;
    }
}

