/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.calendar.stream;

import java.util.Collection;
import java.util.List;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class GoogleCalendarStreamConfiguration
implements Cloneable {
    private static final String DEFAULT_SCOPES = "https://www.googleapis.com/auth/calendar";
    @UriPath
    @Metadata(required=true)
    private String index;
    @UriParam
    private String scopes = "https://www.googleapis.com/auth/calendar";
    @UriParam
    private String clientId;
    @UriParam
    private String applicationName;
    @UriParam(label="security", secret=true)
    private String clientSecret;
    @UriParam(label="security", secret=true)
    private String accessToken;
    @UriParam(label="security", secret=true)
    private String refreshToken;
    @UriParam(label="security", secret=true)
    private String p12FileName;
    @UriParam(label="security", secret=true)
    private String emailAddress;
    @UriParam(label="security", secret=true)
    private String user;
    @UriParam
    private String query;
    @UriParam(defaultValue="10")
    private int maxResults = 10;
    @UriParam(defaultValue="primary")
    private String calendarId = "primary";
    @UriParam(defaultValue="true")
    private boolean consumeFromNow = true;
    @UriParam
    private boolean considerLastUpdate;
    @UriParam
    private boolean syncFlow;
    @UriParam(label="security")
    private String serviceAccountKey;
    @UriParam
    private String delegate;

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getScopes() {
        return this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public Collection<String> getScopesAsList() {
        if (this.scopes != null) {
            return List.of(this.scopes.split(","));
        }
        return null;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getP12FileName() {
        return this.p12FileName;
    }

    public void setP12FileName(String p12FileName) {
        this.p12FileName = p12FileName;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public String getCalendarId() {
        return this.calendarId;
    }

    public void setCalendarId(String calendarId) {
        this.calendarId = calendarId;
    }

    public boolean isConsumeFromNow() {
        return this.consumeFromNow;
    }

    public void setConsumeFromNow(boolean consumeFromNow) {
        this.consumeFromNow = consumeFromNow;
    }

    public boolean isConsiderLastUpdate() {
        return this.considerLastUpdate;
    }

    public void setSyncFlow(boolean syncFlow) {
        this.syncFlow = syncFlow;
    }

    public boolean isSyncFlow() {
        return this.syncFlow;
    }

    public void setConsiderLastUpdate(boolean considerLastUpdate) {
        this.considerLastUpdate = considerLastUpdate;
    }

    public String getServiceAccountKey() {
        return this.serviceAccountKey;
    }

    public void setServiceAccountKey(String serviceAccountKey) {
        this.serviceAccountKey = serviceAccountKey;
    }

    public String getDelegate() {
        return this.delegate;
    }

    public void setDelegate(String delegate) {
        this.delegate = delegate;
    }

    public GoogleCalendarStreamConfiguration copy() {
        try {
            return (GoogleCalendarStreamConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

