/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery.sql;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.support.RowMapper;

public class FieldValueListMapper
implements RowMapper<FieldValueList, Map<String, Object>> {
    private final FieldList schema;

    public FieldValueListMapper(FieldList schema) {
        this.schema = schema;
    }

    public Map<String, Object> map(FieldValueList row) {
        return this.map(this.schema, row);
    }

    private Map<String, Object> map(FieldList schema, FieldValueList row) {
        HashMap<String, Object> rowMap = new HashMap<String, Object>();
        for (int i = 0; i < schema.size(); ++i) {
            Field field = schema.get(i);
            rowMap.put(field.getName(), this.convertValue(field, row.get(i)));
        }
        return rowMap;
    }

    private Object convertValue(Field field, FieldValue fieldValue) {
        return switch (fieldValue.getAttribute()) {
            default -> throw new IncompatibleClassChangeError();
            case FieldValue.Attribute.RECORD -> this.map(field.getSubFields(), fieldValue.getRecordValue());
            case FieldValue.Attribute.REPEATED -> fieldValue.getRepeatedValue().stream().map((? super T element) -> this.convertValue(field, (FieldValue)element)).collect(Collectors.toList());
            case FieldValue.Attribute.RANGE -> fieldValue.getRangeValue().getValues();
            case FieldValue.Attribute.PRIMITIVE -> fieldValue.getValue();
        };
    }
}

