/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.geocoder;

import com.google.maps.GeoApiContext;
import com.google.maps.GeocodingApi;
import com.google.maps.GeolocationApi;
import com.google.maps.errors.InvalidRequestException;
import com.google.maps.errors.OverDailyLimitException;
import com.google.maps.errors.OverQueryLimitException;
import com.google.maps.errors.RequestDeniedException;
import com.google.maps.errors.UnknownErrorException;
import com.google.maps.model.AddressComponent;
import com.google.maps.model.AddressType;
import com.google.maps.model.GeocodingResult;
import com.google.maps.model.GeolocationPayload;
import com.google.maps.model.GeolocationResult;
import com.google.maps.model.LatLng;
import java.util.Locale;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.geocoder.GeoCoderEndpoint;
import org.apache.camel.component.geocoder.GeocoderStatus;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoCoderGoogleProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(GeoCoderGoogleProducer.class);
    private GeoCoderEndpoint endpoint;
    private GeoApiContext context;

    public GeoCoderGoogleProducer(GeoCoderEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        try {
            String latlng;
            String address = (String)exchange.getIn().getHeader("CamelGeoCoderAddress", String.class);
            if (address == null) {
                address = this.endpoint.getAddress();
            }
            if ((latlng = (String)exchange.getIn().getHeader("CamelGeoCoderLatlng", String.class)) == null) {
                latlng = this.endpoint.getLatlng();
            }
            if (latlng != null) {
                String lat = StringHelper.before((String)latlng, (String)",");
                String lng = StringHelper.after((String)latlng, (String)",");
                LatLng latLng = new LatLng(Double.parseDouble(lat), Double.parseDouble(lng));
                LOG.debug("Geocode for lat/lng {}", (Object)latlng);
                Object[] results = (GeocodingResult[])GeocodingApi.reverseGeocode((GeoApiContext)this.context, (LatLng)latLng).await();
                LOG.debug("Geocode response {}", results);
                if (results != null) {
                    this.extractGeoResult((GeocodingResult[])results, exchange);
                }
            } else if (address != null) {
                if ("current".equals(address)) {
                    this.processCurrentLocation(exchange);
                } else {
                    LOG.debug("Geocode for address {}", (Object)address);
                    Object[] results = (GeocodingResult[])GeocodingApi.geocode((GeoApiContext)this.context, (String)address).await();
                    LOG.debug("Geocode response {}", results);
                    if (results != null) {
                        this.extractGeoResult((GeocodingResult[])results, exchange);
                    }
                }
            }
        }
        catch (RequestDeniedException e) {
            exchange.getIn().setHeader("CamelGeoCoderStatus", (Object)GeocoderStatus.REQUEST_DENIED);
        }
        catch (OverQueryLimitException e) {
            exchange.getIn().setHeader("CamelGeoCoderStatus", (Object)GeocoderStatus.OVER_QUERY_LIMIT);
        }
        catch (OverDailyLimitException e) {
            exchange.getIn().setHeader("CamelGeoCoderStatus", (Object)GeocoderStatus.OVER_DAILY_LIMIT);
        }
        catch (InvalidRequestException e) {
            exchange.getIn().setHeader("CamelGeoCoderStatus", (Object)GeocoderStatus.INVALID_REQUEST);
        }
        catch (UnknownErrorException e) {
            exchange.getIn().setHeader("CamelGeoCoderStatus", (Object)GeocoderStatus.UNKNOWN_ERROR);
        }
    }

    protected void processCurrentLocation(Exchange exchange) throws Exception {
        LOG.debug("Geolocation for current location");
        GeolocationPayload payload = new GeolocationPayload();
        payload.considerIp = true;
        GeolocationResult result = (GeolocationResult)GeolocationApi.geolocate((GeoApiContext)this.context, (GeolocationPayload)payload).await();
        LOG.debug("Geolocation response {}", (Object)result);
        exchange.getIn().setHeader("CamelGeoCoderStatus", (Object)GeocoderStatus.OK);
        String resLatlng = result.location.toString();
        exchange.getIn().setHeader("CamelGeoCoderLatlng", (Object)resLatlng);
        LOG.debug("Geocode - reverse geocode for location {}", (Object)resLatlng);
        Object[] results = (GeocodingResult[])GeocodingApi.reverseGeocode((GeoApiContext)this.context, (LatLng)result.location).await();
        LOG.debug("Geocode response {}", results);
        if (results != null) {
            this.extractGeoResult((GeocodingResult[])results, exchange);
        }
    }

    private void setLatLngToExchangeHeader(LatLng location, Exchange exchange) {
        double resLat = location.lat;
        double resLng = location.lng;
        exchange.getIn().setHeader("CamelGeoCoderLat", (Object)this.formatLatOrLon(resLat));
        exchange.getIn().setHeader("CamelGeoCoderLng", (Object)this.formatLatOrLon(resLng));
        String resLatlng = location.toString();
        exchange.getIn().setHeader("CamelGeoCoderLatlng", (Object)resLatlng);
    }

    protected void extractGeoResult(GeocodingResult[] res, Exchange exchange) {
        AddressComponent region;
        AddressComponent postalCode;
        AddressComponent city;
        if (!this.endpoint.isHeadersOnly()) {
            exchange.getIn().setBody((Object)res);
        }
        if (res.length == 0) {
            exchange.getIn().setHeader("CamelGeoCoderStatus", (Object)GeocoderStatus.ZERO_RESULTS);
            return;
        }
        exchange.getIn().setHeader("CamelGeoCoderStatus", (Object)GeocoderStatus.OK);
        GeocodingResult first = res[0];
        exchange.getIn().setHeader("CamelGeoCoderAddress", (Object)first.formattedAddress);
        this.setLatLngToExchangeHeader(first.geometry.location, exchange);
        AddressComponent country = GeoCoderGoogleProducer.getCountry(res);
        if (country != null) {
            exchange.getIn().setHeader("CamelGeoCoderCountryShort", (Object)country.shortName);
            exchange.getIn().setHeader("CamelGeoCoderCountryLong", (Object)country.longName);
        }
        if ((city = GeoCoderGoogleProducer.getCity(res)) != null) {
            exchange.getIn().setHeader("CamelGeoCoderCity", (Object)city.longName);
        }
        if ((postalCode = GeoCoderGoogleProducer.getPostalCode(res)) != null) {
            exchange.getIn().setHeader("CamelGeoCoderPostalCode", (Object)postalCode.shortName);
        }
        if ((region = GeoCoderGoogleProducer.getRegion(res)) != null) {
            exchange.getIn().setHeader("CamelGeoCoderRegionCode", (Object)region.shortName);
            exchange.getIn().setHeader("CamelGeoCoderRegionName", (Object)region.longName);
        }
    }

    private String formatLatOrLon(double value) {
        return String.format(Locale.ENGLISH, "%.8f", value);
    }

    private static AddressComponent getComponent(GeocodingResult[] results, AddressType addressType) {
        for (GeocodingResult result : results) {
            for (AddressType type : result.types) {
                if (type != addressType || result.addressComponents.length <= 0) continue;
                return result.addressComponents[0];
            }
        }
        return null;
    }

    private static AddressComponent getCountry(GeocodingResult[] res) {
        return GeoCoderGoogleProducer.getComponent(res, AddressType.COUNTRY);
    }

    private static AddressComponent getCity(GeocodingResult[] res) {
        return GeoCoderGoogleProducer.getComponent(res, AddressType.LOCALITY);
    }

    private static AddressComponent getPostalCode(GeocodingResult[] res) {
        return GeoCoderGoogleProducer.getComponent(res, AddressType.POSTAL_CODE);
    }

    private static AddressComponent getRegion(GeocodingResult[] res) {
        return GeoCoderGoogleProducer.getComponent(res, AddressType.ADMINISTRATIVE_AREA_LEVEL_1);
    }

    protected void doStart() {
        this.context = this.endpoint.createGeoApiContext();
    }
}

