/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.geocoder;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.geocoder.GeoCoderEndpoint;
import org.apache.camel.component.geocoder.GeocoderStatus;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoCoderNominatimProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(GeoCoderNominatimProducer.class);
    private GeoCoderEndpoint endpoint;

    public GeoCoderNominatimProducer(GeoCoderEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        String latlng;
        String address = (String)exchange.getIn().getHeader("CamelGeoCoderAddress", String.class);
        if (address == null) {
            address = this.endpoint.getAddress();
        }
        if ((latlng = (String)exchange.getIn().getHeader("CamelGeoCoderLatlng", String.class)) == null) {
            latlng = this.endpoint.getLatlng();
        }
        String geocoded = null;
        if (latlng != null) {
            String lat = StringHelper.before((String)latlng, (String)",");
            String lng = StringHelper.after((String)latlng, (String)",");
            LOG.debug("Geocode for lat/lng {}", (Object)latlng);
            geocoded = this.query(lat, lng);
        } else if (address != null) {
            LOG.debug("Geocode for address {}", (Object)address);
            geocoded = this.query(address);
        }
        LOG.debug("Geocode response {}", geocoded);
        this.extractResult(geocoded, exchange);
    }

    private String query(String dlat, String dlon) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "jsonv2");
        params.put("lat", dlat);
        params.put("lon", dlon);
        return this.queryForString("reverse", params);
    }

    private String query(String address) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "jsonv2");
        params.put("addressdetails", "1");
        params.put("q", address);
        params.put("limit", "1");
        return this.queryForString("search", params);
    }

    /*
     * Exception decompiling
     */
    private String queryForString(String operation, Map<String, String> params) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void extractResult(String place, Exchange exchange) {
        if (!this.endpoint.isHeadersOnly()) {
            exchange.getIn().setBody((Object)place);
        }
        if (place == null || place.isEmpty()) {
            exchange.getIn().setHeader("CamelGeoCoderStatus", (Object)GeocoderStatus.ZERO_RESULTS);
            return;
        }
        exchange.getIn().setHeader("CamelGeoCoderStatus", (Object)GeocoderStatus.OK);
        if (place.startsWith("[") && place.endsWith("]")) {
            place = place.substring(1, place.length() - 1);
        }
        Configuration conf = Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});
        DocumentContext doc = JsonPath.using((Configuration)conf).parse(place);
        exchange.getIn().setHeader("CamelGeoCoderAddress", doc.read("$['display_name']", new Predicate[0]));
        this.setLatLngToExchangeHeader((String)doc.read("$['lat']", new Predicate[0]), (String)doc.read("$['lon']", new Predicate[0]), exchange);
        this.extractCountry(doc, exchange.getIn());
        this.extractCity(doc, exchange.getIn());
        this.extractPostalCode(doc, exchange.getIn());
        this.extractRegion(doc, exchange.getIn());
    }

    private void setLatLngToExchangeHeader(String resLat, String resLng, Exchange exchange) {
        exchange.getIn().setHeader("CamelGeoCoderLat", (Object)this.formatLatOrLon(resLat));
        exchange.getIn().setHeader("CamelGeoCoderLng", (Object)this.formatLatOrLon(resLng));
        String resLatlng = this.formatLatOrLon(resLat) + ", " + this.formatLatOrLon(resLng);
        exchange.getIn().setHeader("CamelGeoCoderLatlng", (Object)resLatlng);
    }

    private void extractCountry(DocumentContext doc, Message in) {
        String code = (String)doc.read("$['address']['country_code']", new Predicate[0]);
        if (code != null) {
            code = code.toUpperCase();
        }
        in.setHeader("CamelGeoCoderCountryShort", (Object)code);
        in.setHeader("CamelGeoCoderCountryLong", doc.read("$['address']['country']", new Predicate[0]));
    }

    private void extractCity(DocumentContext doc, Message in) {
        in.setHeader("CamelGeoCoderCity", doc.read("$['address']['city']", new Predicate[0]));
    }

    private void extractPostalCode(DocumentContext doc, Message in) {
        in.setHeader("CamelGeoCoderPostalCode", doc.read("$['address']['postcode']", new Predicate[0]));
    }

    private void extractRegion(DocumentContext doc, Message in) {
        String code = (String)doc.read("$['address']['state_code']", new Predicate[0]);
        if (code != null) {
            code = code.toUpperCase();
        }
        in.setHeader("CamelGeoCoderRegionCode", (Object)code);
        in.setHeader("CamelGeoCoderRegionName", doc.read("$['address']['state']", new Predicate[0]));
    }

    private String formatLatOrLon(String value) {
        return String.format(Locale.ENGLISH, "%.8f", Double.parseDouble(value));
    }
}

