/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import org.apache.camel.component.file.GenericFile;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteFile<T>
extends GenericFile<T>
implements Cloneable {
    private String hostname;

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public char getFileSeparator() {
        return '/';
    }

    protected boolean isAbsolute(String name) {
        return name.startsWith("" + this.getFileSeparator());
    }

    protected String normalizePath(String name) {
        return name;
    }

    public RemoteFile<T> copyFrom(RemoteFile<T> source) {
        RemoteFile result;
        try {
            result = (RemoteFile)source.getClass().newInstance();
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        result.setEndpointPath(source.getEndpointPath());
        result.setAbsolute(source.isAbsolute());
        result.setAbsoluteFilePath(source.getAbsoluteFilePath());
        result.setRelativeFilePath(source.getRelativeFilePath());
        result.setFileName(source.getFileName());
        result.setFileNameOnly(source.getFileNameOnly());
        result.setFileLength(source.getFileLength());
        result.setLastModified(source.getLastModified());
        result.setFile(source.getFile());
        result.setBody(source.getBody());
        result.setBinding(source.getBinding());
        result.setHostname(source.getHostname());
        return result;
    }

    protected String normalizePathToProtocol(String path) {
        path = super.normalizePathToProtocol(path);
        return FileUtil.stripLeadingSeparator((String)path);
    }
}

