/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.freemarker.FreemarkerConstants;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.10.0", scheme="freemarker", title="Freemarker", syntax="freemarker:resourceUri", remote=false, producerOnly=true, category={Category.TRANSFORMATION}, headersClass=FreemarkerConstants.class)
public class FreemarkerEndpoint
extends ResourceEndpoint {
    @UriParam(defaultValue="false")
    private boolean allowTemplateFromHeader;
    @UriParam
    private String encoding;
    @UriParam
    private int templateUpdateDelay;
    @UriParam
    private Configuration configuration;

    public FreemarkerEndpoint() {
    }

    public FreemarkerEndpoint(String uri, Component component, String resourceUri) {
        super(uri, component, resourceUri);
    }

    public boolean isRemote() {
        return false;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "freemarker:" + this.getResourceUri();
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getTemplateUpdateDelay() {
        return this.templateUpdateDelay;
    }

    public void setTemplateUpdateDelay(int templateUpdateDelay) {
        this.templateUpdateDelay = templateUpdateDelay;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public FreemarkerEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.getResourceUri(), newResourceUri);
        this.log.debug("Getting endpoint with URI: {}", (Object)newUri);
        return (FreemarkerEndpoint)this.getCamelContext().getEndpoint(newUri, FreemarkerEndpoint.class);
    }

    public void clearContentCache() {
        this.configuration.clearTemplateCache();
    }

    protected void onExchange(Exchange exchange) throws Exception {
        Template template;
        String newResourceUri;
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        ObjectHelper.notNull((Object)path, (String)"resourceUri");
        if (this.allowTemplateFromHeader && (newResourceUri = (String)exchange.getIn().getHeader("CamelFreemarkerResourceUri", String.class)) != null) {
            exchange.getIn().removeHeader("CamelFreemarkerResourceUri");
            this.log.debug("{} set to {} creating new endpoint to handle exchange", (Object)"CamelFreemarkerResourceUri", (Object)newResourceUri);
            FreemarkerEndpoint newEndpoint = this.findOrCreateEndpoint(this.getEndpointUri(), newResourceUri);
            newEndpoint.onExchange(exchange);
            return;
        }
        Reader reader = null;
        String content = null;
        if (this.allowTemplateFromHeader) {
            content = (String)exchange.getIn().getHeader("CamelFreemarkerTemplate", String.class);
        }
        if (content != null) {
            reader = new StringReader(content);
            exchange.getIn().removeHeader("CamelFreemarkerTemplate");
        }
        Object dataModel = null;
        if (this.allowTemplateFromHeader) {
            dataModel = exchange.getIn().getHeader("CamelFreemarkerDataModel", Object.class);
        }
        if (dataModel == null) {
            dataModel = ExchangeHelper.createVariableMap((Exchange)exchange, (boolean)this.isAllowContextMapAll());
        }
        if (reader == null && ResourceHelper.hasScheme((String)path)) {
            reader = new InputStreamReader(this.getResourceAsInputStream());
        }
        if (reader != null) {
            this.log.debug("Freemarker is evaluating template read from header {} using context: {}", (Object)"CamelFreemarkerTemplate", dataModel);
            template = new Template("temp", reader, this.configuration);
        } else {
            this.log.debug("Freemarker is evaluating {} using context: {}", (Object)path, dataModel);
            template = this.getEncoding() != null ? this.configuration.getTemplate(path, this.getEncoding()) : this.configuration.getTemplate(path);
        }
        StringWriter buffer = new StringWriter();
        template.process(dataModel, (Writer)buffer);
        buffer.flush();
        ExchangeHelper.setInOutBodyPatternAware((Exchange)exchange, (Object)buffer.toString());
    }
}

