/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flowable;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.support.DefaultProducer;
import org.flowable.eventregistry.api.InboundEvent;
import org.flowable.eventregistry.impl.DefaultInboundEvent;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.model.CamelInboundChannelModel;
import org.flowable.eventregistry.model.InboundChannelModel;

public class FlowableProducer
extends DefaultProducer {
    protected CamelInboundChannelModel camelInboundChannel;
    protected EventRegistryEngineConfiguration eventRegistryEngineConfiguration;

    public FlowableProducer(CamelInboundChannelModel camelInboundChannel, Endpoint endpoint, EventRegistryEngineConfiguration eventRegistryEngineConfiguration) {
        super(endpoint);
        this.camelInboundChannel = camelInboundChannel;
        this.eventRegistryEngineConfiguration = eventRegistryEngineConfiguration;
    }

    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getMessage();
        DefaultInboundEvent inboundEvent = new DefaultInboundEvent(message.getBody(), message.getHeaders());
        this.eventRegistryEngineConfiguration.getEventRegistry().eventReceived((InboundChannelModel)this.camelInboundChannel, (InboundEvent)inboundEvent);
    }
}

