/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flink;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.flink.DataSetCallback;
import org.apache.camel.component.flink.DataStreamCallback;
import org.apache.camel.component.flink.EndpointType;
import org.apache.camel.component.flink.FlinkEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.streaming.api.datastream.DataStream;

@Component(value="flink")
public class FlinkComponent
extends DefaultComponent {
    @Metadata
    private DataSet ds;
    @Metadata
    private DataSetCallback dataSetCallback;
    @Metadata
    private DataStream dataStream;
    @Metadata
    private DataStreamCallback dataStreamCallback;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null) {
            throw new IllegalArgumentException("The endpointType must be configured in endpoint uri: " + uri);
        }
        EndpointType type = (EndpointType)((Object)this.getCamelContext().getTypeConverter().mandatoryConvertTo(EndpointType.class, (Object)remaining));
        return new FlinkEndpoint(uri, this, type);
    }

    public DataSet getDataSet() {
        return this.ds;
    }

    @Deprecated(since="4.16.0")
    public void setDataSet(DataSet ds) {
        this.ds = ds;
    }

    public DataStream getDataStream() {
        return this.dataStream;
    }

    public void setDataStream(DataStream dataStream) {
        this.dataStream = dataStream;
    }

    public DataSetCallback getDataSetCallback() {
        return this.dataSetCallback;
    }

    @Deprecated(since="4.16.0")
    public void setDataSetCallback(DataSetCallback dataSetCallback) {
        this.dataSetCallback = dataSetCallback;
    }

    public DataStreamCallback getDataStreamCallback() {
        return this.dataStreamCallback;
    }

    public void setDataStreamCallback(DataStreamCallback dataStreamCallback) {
        this.dataStreamCallback = dataStreamCallback;
    }
}

