/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flatpack;

import net.sf.flatpack.DataSet;
import net.sf.flatpack.Parser;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.flatpack.FixedLengthEndpoint;
import org.apache.camel.impl.DefaultProducer;

class FlatpackProducer
extends DefaultProducer {
    private FixedLengthEndpoint endpoint;

    public FlatpackProducer(FixedLengthEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        Parser parser = this.endpoint.createParser(exchange);
        DataSet dataSet = parser.parse();
        if (this.endpoint.isSplitRows()) {
            int counter = 0;
            while (dataSet.next()) {
                this.endpoint.processDataSet(dataSet, counter++);
            }
        } else {
            this.endpoint.processDataSet(dataSet, dataSet.getRowCount());
        }
    }
}

