/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.LoggingExceptionHandler;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericFileOnCompletion<T>
implements Synchronization {
    private static final Logger LOG = LoggerFactory.getLogger(GenericFileOnCompletion.class);
    private final GenericFileEndpoint<T> endpoint;
    private final GenericFileOperations<T> operations;
    private final GenericFileProcessStrategy<T> processStrategy;
    private ExceptionHandler exceptionHandler;
    private final GenericFile<T> file;
    private final String absoluteFileName;

    public GenericFileOnCompletion(GenericFileEndpoint<T> endpoint, GenericFileOperations<T> operations, GenericFileProcessStrategy processStrategy, GenericFile<T> file, String absoluteFileName) {
        this.endpoint = endpoint;
        this.operations = operations;
        this.processStrategy = processStrategy;
        this.file = file;
        this.absoluteFileName = absoluteFileName;
        this.exceptionHandler = endpoint.getOnCompletionExceptionHandler();
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(endpoint.getCamelContext(), this.getClass());
        }
    }

    public void onComplete(Exchange exchange) {
        this.onCompletion(exchange);
    }

    public void onFailure(Exchange exchange) {
        this.onCompletion(exchange);
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCompletion(Exchange exchange) {
        LOG.debug("Done processing file: {} using exchange: {}", this.file, (Object)exchange);
        boolean committed = false;
        try {
            boolean failed = exchange.isFailed();
            if (!failed) {
                this.processStrategyCommit(this.processStrategy, exchange, this.file);
                committed = true;
            }
        }
        finally {
            if (!committed) {
                this.processStrategyRollback(this.processStrategy, exchange, this.file);
            }
            this.endpoint.getInProgressRepository().remove(this.absoluteFileName);
        }
    }

    protected void processStrategyCommit(GenericFileProcessStrategy<T> processStrategy, Exchange exchange, GenericFile<T> file) {
        if (Boolean.TRUE.equals(this.endpoint.isIdempotent())) {
            String key = this.absoluteFileName;
            if (this.endpoint.getIdempotentKey() != null) {
                Exchange dummy = this.endpoint.createExchange(file);
                key = (String)this.endpoint.getIdempotentKey().evaluate(dummy, String.class);
            }
            if (key != null) {
                if (this.endpoint.isIdempotentEager()) {
                    this.endpoint.getIdempotentRepository().confirm(key);
                } else {
                    this.endpoint.getIdempotentRepository().add(key);
                }
            }
        }
        this.handleDoneFile(exchange);
        try {
            LOG.trace("Commit file strategy: {} for file: {}", processStrategy, file);
            processStrategy.commit(this.operations, this.endpoint, exchange, file);
        }
        catch (Exception e) {
            this.handleException("Error during commit", exchange, e);
        }
    }

    protected void processStrategyRollback(GenericFileProcessStrategy<T> processStrategy, Exchange exchange, GenericFile<T> file) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("Rollback file strategy: {} for file: {}", processStrategy, file);
        }
        if (Boolean.TRUE.equals(this.endpoint.isIdempotent())) {
            String key = this.absoluteFileName;
            if (this.endpoint.getIdempotentKey() != null) {
                Exchange dummy = this.endpoint.createExchange(file);
                key = (String)this.endpoint.getIdempotentKey().evaluate(dummy, String.class);
            }
            if (key != null) {
                this.endpoint.getIdempotentRepository().remove(key);
            }
        }
        if (this.endpoint.getMoveFailed() != null) {
            this.handleDoneFile(exchange);
        }
        try {
            processStrategy.rollback(this.operations, this.endpoint, exchange, file);
        }
        catch (Exception e) {
            this.handleException("Error during rollback", exchange, e);
        }
    }

    protected void handleDoneFile(Exchange exchange) {
        boolean complete = (Boolean)exchange.getProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)false, Boolean.class);
        if (this.endpoint.getDoneFileName() != null && !this.endpoint.isNoop()) {
            String doneFileName = this.endpoint.createDoneFileName(this.absoluteFileName);
            StringHelper.notEmpty((String)doneFileName, (String)"doneFileName", this.endpoint);
            if (this.endpoint.getDoneFileName().contains("{file:name") || complete) {
                try {
                    boolean deleted = this.operations.deleteFile(doneFileName);
                    LOG.trace("Done file: {} was deleted: {}", (Object)doneFileName, (Object)deleted);
                    if (!deleted) {
                        LOG.warn("Done file: {} could not be deleted", (Object)doneFileName);
                    }
                }
                catch (Exception e) {
                    this.handleException("Error deleting done file: " + doneFileName, exchange, e);
                }
            }
        }
    }

    protected void handleException(String message, Exchange exchange, Throwable t) {
        Throwable newt = t == null ? new IllegalArgumentException("Handling [null] exception") : t;
        this.getExceptionHandler().handleException(message, exchange, newt);
    }

    public String toString() {
        return "GenericFileOnCompletion";
    }
}

