/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.GenericFileRenameExclusiveReadLockStrategy;
import org.apache.camel.component.file.strategy.MarkerFileExclusiveReadLockStrategy;

public class FileRenameExclusiveReadLockStrategy
extends GenericFileRenameExclusiveReadLockStrategy<File> {
    private final MarkerFileExclusiveReadLockStrategy marker = new MarkerFileExclusiveReadLockStrategy();
    private boolean markerFile = true;

    @Override
    public boolean acquireExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        if (this.markerFile && !this.marker.acquireExclusiveReadLock(operations, file, exchange)) {
            return false;
        }
        return super.acquireExclusiveReadLock(operations, file, exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseExclusiveReadLockOnAbort(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        try {
            if (this.markerFile) {
                this.marker.releaseExclusiveReadLockOnAbort(operations, file, exchange);
            }
        }
        finally {
            super.releaseExclusiveReadLockOnAbort(operations, file, exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseExclusiveReadLockOnRollback(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        try {
            if (this.markerFile) {
                this.marker.releaseExclusiveReadLockOnRollback(operations, file, exchange);
            }
        }
        finally {
            super.releaseExclusiveReadLockOnRollback(operations, file, exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseExclusiveReadLockOnCommit(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        try {
            if (this.markerFile) {
                this.marker.releaseExclusiveReadLockOnCommit(operations, file, exchange);
            }
        }
        finally {
            super.releaseExclusiveReadLockOnCommit(operations, file, exchange);
        }
    }

    @Override
    public void setMarkerFiler(boolean markerFile) {
        this.markerFile = markerFile;
    }
}

